proc(t)=RSteiler(x)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also   	RShurst 
; ---------------------------------------------------------------------
; Macro       RSteiler
; ---------------------------------------------------------------------
; Description Selection of the laglength of a series for calculation
;							of the Hurst coefficient by RShurst
; ---------------------------------------------------------------------
; Usage       (t)=RSteiler(x)
; Input       
; Parameter   x	series to be estimated
; Definition  
; Output      
; Parameter   t vector of selected laglengths, first 9 (if possible),
; Definition  	last floor(n/2)
; ---------------------------------------------------------------------
; Notes       can be customized by setting the starting value (a0) for
;							the shortes laglength and the steplength in the procedure
;							to different values
; ---------------------------------------------------------------------
; Example     x=normal(200)
;							t=RSteiler(x)
; ---------------------------------------------------------------------
; Result      [1,]    9
;							[2,]   13
;							[3,]   22
;							[4,]   40
;							[5,]   60
;							[6,]  100
; ---------------------------------------------------------------------
; Keywords    self similarity, long memory
; ---------------------------------------------------------------------
; Reference   
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Arne Wuensche 000410
; ---------------------------------------------------------------------
//
n=rows(x)
a0=9
steplength=4
a=a0-1
teiler=matrix(n/4)
j=1
i=0
while(a<=floor(n/2))
  a=a+1
    if (floor(n/(a+1))<floor(n/a))
			if (a-teiler[j]>=(steplength*(j-1)))
      	j=j+1
      	teiler[j]=a
			endif
    endif
endo
teiler2=matrix(j-1) 
do 
  i=i+1
  teiler2[i]=teiler[i+1]
until (i>=j-1)
t=teiler2
endp