proc()=VaRqqplot(y,VaR, VaR1,VaR2,VaR3, opt)
;------------------------------------------------------------------------
; Library	VaR
;------------------------------------------------------------------------
; See_also	VaRest VaRopt VaRtimeplot
;------------------------------------------------------------------------
; Macro		VaRqqplot
;------------------------------------------------------------------------
; Description   visualizes the reliability of VaR forecasts. 
; ----------------------------------------------------------------------------
;   Keywords    VaR
; ----------------------------------------------------------------------- 
; Usage		VaRqq(y,VaR{,VaR1,{,VaR2{,VaR3}}}{,opt})
;     Input 
;       Parameter   y  
;         Definition    n x d  matrix, the returns of d time series.
;       Parameter   VaR  
;         Definition    (n-h) x 1 or (n-h) x 2  matrix, VaR forecasts.
;       Parameter   VaR1  
;         Definition    (n-h) x 1 or (n-h) x 2  matrix, VaR forecasts.
;       Parameter   VaR2  
;         Definition    (n-h) x 1 or (n-h) x 2  matrix, VaR forecasts.
;       Parameter   VaR3  
;         Definition    (n-h) x 1 or (n-h) x 2  matrix, VaR forecasts.
;       Parameter   opt
;         Definition    optional, a list with optional input. The function
;                       "VaRopt" can be used to set up this parameter.
;                       The order of the list elements is not important.
;                       Parameters which are not given are replaced by 
;                       defaults (see below).
;       Parameter   opt.h
;         Definition    positive integer, window width. 
;                       If not given, set to 250.
;       Parameter   opt.name
;         Definition    string, prefix for the output. If not given, "VaR"
;                       is used.
;       Parameter   opt.title
;         Definition    string, title for the output. If not given, a default
;                       is set.
;       Parameter   opt.color
;         Definition    string vector, colors for different VaR
;                       functions. Possible values are the color
;                       strings from setmask. The default is "black".
;     Output
;       Parameter   VaRqqplot
;         Definition    or  opt.name+"qqplot",
;                       display, containing portfolio data and VaR 
;                       forecasts.
;--------------------------------------------------------------------
;   Example   library("VaR")
;             x=read("kupfer")      ; time series
;             x=x[1:1001]  
;             y=diff(log(x))        ; returns
;             VaR=VaRest(y)         ; VaR 
;             VaRqqplot(y,VaR)      ; QQ plot
; -----------------------------------------------------------------
;   Result    The VaR is estimated and a QQ plot of y/VaR is
;             displayed.
; ----------------------------------------------------------------------------
;   Example   library("VaR")
;             x=read("kupfer")       ; time series
;             x=x[1:1001]  
;             y=diff(log(x))         ; returns
;             VaRrma=VaRest(y,"RMA") ; VaR using RMA 
;             VaRema=VaRest(y,"EMA") ; VaR using EMA
;             VaRmad=VaRest(y,"MAD") ; VaR using MAD
;             opt=VaRopt("color","red"|"blue"|"green")
;             VaRtimeplot(y,VaRrma,VaRema,VaRmad,opt)  
;             VaRqqplot(y,VaRrma,VaRema,VaRmad,opt)
; ----------------------------------------------------------------------------
;   Result    The VaR forecasts (using methods RMA, EMA and MAD) are
;             estimated and plotted together with the portfolio
;             returns. Additionally, QQ plots of y/VaR are 
;             displayed.
; ----------------------------------------------------------------------------
;   Author    Marlene Mueller, 2000/07/13
; ----------------------------------------------------------------------------
  bad=(rows(dim(y))>2)
  error(bad>0,"y must be vector or matrix")
;
  n=rows(y)
  d=cols(y)
;
  nov=1+(exist(VaR1)==1)+(exist(VaR2)==1)+(exist(VaR3)==1)
  if (exist(VaR1)==9)
    opt=VaR1
  else
    if (exist(VaR2)==9)
      opt=VaR2
    else
      if (exist(VaR3)==9)
        opt=VaR3
      endif
    endif
  endif
;
; set the defaults
;
  name="VaR"
  title="VaR reliability plot"
  color="black"
  style="fillcircle"
  size ="small"
  h=250
  w=matrix(1,d)
;
; now check which optional values have been given
;
  if (exist(opt)>0)
    if (comp(opt,"h")>0)
      opt.h=opt.h[1]
      notgood=(opt.h>=n-1)||(opt.h<2)
      error(notgood>0, "VaRest: Window width h is unusable")
      if (notgood==0)
        h=opt.h
      endif
    endif
    if (comp(opt,"w")>0)
      notgood=((cols(opt.w)!=d)&&(cols(opt.w!=1)))
      notgood=notgood || ((rows(opt.w)!=n)&&(rows(opt.w!=1)))
      if (notgood==0)
        w=opt.w
      endif
    endif
    if (comp(opt,"name")>0)
      name=opt.name
    endif
    if (comp(opt,"title")>0)
      title=opt.title
    endif
    if (comp(opt,"color")>0)
      color=opt.color
    endif
    if (comp(opt,"style")>0)
      style=opt.style
    endif
    if (comp(opt,"size")>0)
      size=opt.size
    endif
  endif
;
  p=sum(y.*w,2) ; portfolio
;
  p=p[(h+1):n]
  qn=qfn(((1:(n-h))-0.5)./(n-h))
  tmp=p./VaR[,1]
  line=(min(-4|min(qn)|min(tmp))|max(4|max(qn)|max(tmp)))
  VaRqq=setmask(sort(qn~tmp,0),color[1],"fillcircle","small")
  if (nov>1)
    tmp=p./VaR1[,1]
    line=min(line[1]|min(tmp))|max(line[2]|max(tmp))
    VaR1qq=setmask(sort(qn~tmp,0),color[2],"fillcircle","small")
  endif
  if (nov>2)
    tmp=p./VaR2[,1]
    line=min(line[1]|min(tmp))|max(line[2]|max(tmp))
    VaR2qq=setmask(sort(qn~tmp,0),color[3],"fillcircle","small")
  endif
  if (nov>3)
    tmp=p./VaR3[,1]
    line=min(line[1]|min(tmp))|max(line[2]|max(tmp))
    VaR3qq=setmask(sort(qn~tmp,0),color[4],"fillcircle","small")
  endif
  line=setmask(line.*(1~1),"line","black","thin")
;
  exec( name+"qqplot=createdisplay(1,1)" )
  if (nov==1)
    exec("show("+name+"qqplot,1, 1, line, VaRqq)")
  endif
  if (nov==2)
    exec("show("+name+"qqplot,1, 1, line, VaRqq, VaR1qq)")
  endif
  if (nov==3)
    exec("show("+name+"qqplot,1, 1, line, VaRqq, VaR1qq, VaR2qq)")
  endif
  if (nov==4)
    exec("show("+name+"qqplot,1, 1, line, VaRqq, VaR1qq, VaR2qq, VaR3qq)")
  endif
;
  tl="title"
  titl=title
  xl="xlabel"
  xlabl="normal quantiles"
  yl="ylabel"
  ylabl="L/VaR quantiles"
  exec( "setgopt("+name+"qqplot,1,1,tl,titl,xl,xlabl,yl,ylabl)" )
endp




