proc(dummy)=acfplot(x,maxlag)
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  acf,pacf,pacfplot,fft,invfft
; ----------------------------------------------------------------------
;   Macro	  acfplot
; ----------------------------------------------------------------------
;   Description   plots the autocorrelation function
;                 of a time series.                
; ----------------------------------------------------------------------
;   Usage         acfplot(x {, maxlag})
;   Input 
;     Parameter   x 
;     Definition  vector (time series)
;     Parameter   maxlag (optional)
;     Definition  Integer (maximum lag plotted, default 30)
; ----------------------------------------------------------------------
;   Example       library("times")
;                 x=normal(100)
;		              acfplot(x)
; ----------------------------------------------------------------------
;   Result        generates a graphical object wich represents the 
;                 autocorrelation function of a time series
; ----------------------------------------------------------------------
;   Author        Rong Chen, Christian Hafner, 970724
; ----------------------------------------------------------------------
if (exist(maxlag)==0)
  maxlag=30
endif
n=rows(x)
aa=acf(x)[1:maxlag]
bb=matrix(maxlag,2)*0
cc=vec((aa[1:maxlag]~bb)')
c1=0:(maxlag-1)
c2=1:(maxlag)
dd=vec((c1~c1~c2)')
dacf=createdisplay(1,1)
w=dd~cc
w=setmask(w,"line", "solid")
s1=(0|maxlag)~((1|1)*2/sqrt(n))
s2=(0|maxlag)~((1|1)*(-2)/sqrt(n))
s1=setmask(s1,"line", "dashed")
s2=setmask(s2,"line", "dashed")
show(dacf,1,1,w,s1,s2)
setgopt(dacf,1,1,"xlabel","lag","ylabel","acf" )
dummy=0
endp
