proc(b, c, v, s, a)=adaptive(x, k, w, m, t)          
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also     adap
; -----------------------------------------------------------------------
; Macro        adaptive
; -----------------------------------------------------------------------
; Description  performs an adaptive K-means cluster analysis
;              with appropriate (adaptive) multivariate
;              graphic using the principal components
; -----------------------------------------------------------------------
; Usage        ca = adaptive(x, k, w, m, t) 
; Input
;   Parameter  x
;   Definition n x p  matrix of n row points to be clustered
;   Parameter  k
;   Definition scalar the number of clusters   
;   Parameter  w
;   Definition p x 1  matrix of weights of column points
;   Parameter  m
;   Definition n x 1  matrix of weights (masses) of row points
;   Parameter  t
;   Definition n x 1  matrix of the true partition (only if known,
;                     else a matrix containing 1)
; Output
;   Parameter  ca.b
;   Definition n x 1  matrix partition of n points into k clusters
;   Parameter  ca.c
;   Definition k x p  matrix of means (centroids) of clusters
;   Parameter  ca.v
;   Definition k x p  matrix of within cluster variances divided by
;                     the corresponding weights (masses) of clusters
;   Parameter  ca.s
;   Definition k x 1  matrix of weights (masses) of clusters
;   Parameter  ca.a
;   Definition p x 1  matrix of adaptive weights of variables
; -----------------------------------------------------------------------
; Example     ; load the library xclust
;             library ("xclust")
;             ; initialize random generator
;             randomize(0)
;             ; generate some normal data
;             x  = normal(200, 5)
;             x1 = x - #(2,1,3,0,0)' 
;             x2 = x + #(1,1,3,1,0.5)'                                   
;             x3 = x + #(0,0,1,5,1)'    
;             ; make one data set
;             x  = x1|x2|x3
;             ; compute column variances
;             w  = 1./var(x)
;             ; generate row weights (here : 1)
;             m  = matrix(rows(x))
;             ; generate true partition
;             t  = matrix(200)|matrix(200).+1|matrix(200).+2 
;             ; apply adaptive clustering
;             ca = adaptive (x, 3, w, m, t)
; -----------------------------------------------------------------------
; Result      gives a partition ca.b of n row points into 3 clusters which 
;             minimizes the sum of within cluster variances according
;             to the column weights (1/pooled within cluster variances)
; -----------------------------------------------------------------------
; Author      Hans-Joachim Mucha, 941111
;             Sigbert Klinke, 970902
; -----------------------------------------------------------------------
oldvar=var(x).*w
cond = 1
ind=1
while (cond.>0.001)
   e=ceil(uniform(rows(x)).*k)
   {b, c, v, s}=kmeans(x, e, 1, w', m)
   u=x.*(trans(sqrt(w')))
   g=cov(u)
   {a, bev}=eigsm(g)
   g=a~trans(bev)
   g=sort(g, (-1))
   q=trans(g[,2:cols(g)])
   h=mean(u)
   i=(u-h)*q
   if(ind)
     if(k.<3)             ; plot of the given class membership
       dataview = createdisplay(1,1)j=i[,1:2]
       setmaskp (j, t)
       show(dataview, 1, 1, j)
       "Quality of axes:"
       g[,1]~(g[,1].*100./sum(g[,1]))      ; quality of axes
     endif
     string ("Contingency table true - estimated partition (cond=%g)", cond)     conting(t, b)
   endif
   w=sum(s)./(s'*v)        ; xty(v, s)
   a=var(x).*w
   cond=sum(abs(oldvar-a))
   oldvar=a
   ind=0
endo
  setsize (640, 480)
  adapdisp = createdisplay(1,2)
  j=i[,1:2]
  setmaskp (j, t)
  show(adapdisp, 1, 1, j)
  setgopt (adapdisp, 1, 1, "title", "true partition")
  j=i[,1:2]
  setmaskp (j, b)
  show(adapdisp, 1,2, j)
  setgopt (adapdisp, 1, 2, "title", "estimated partition")
  "Final quality of axes"
  g[,1]~(g[,1].*100./sum(g[,1]))
  "Final Contingency table true - estimated partition"
  conting(t, b)
endp
