proc(y)=addfnci(ff,ord,dy,di,b,e,a)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  domulti
; ----------------------------------------------------------------------
;   Macro	  addfnci
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for cointegration
; ----------------------------------------------------------------------
;   Usage         y = addfnci(ff,ord,dy,di,b,e,a)
;   Input 
;     Parameter   ff 
;     Definition     function 
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   dy 
;     Definition     matrix, differenced time series
;     Parameter   di 
;     Definition     integer, dimension of time series
;     Parameter   e 
;     Definition     vector 
;     Parameter   a 
;     Definition     vector 
;   Output
;     Parameter   y
;     Definition     matrix
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Stefan Sperlich 971215
; ----------------------------------------------------------------------
t=e-b+1
sw =( min ( floor (8100/(1+di*ord)-ord)|t))'
n=(ceil(t/sw))'
i=aseq(b,n,sw)
j=i+sw-1
j[n,1]=e
k=1
x=0
 while (k<=n)
   z=zgenci(dy,ord,i[k,1],j[k,1],di)
   y=_ff(x,z,i[k,1],j[k,1],a,b)
   k=k+1
 endo
endp
