proc(rho,tau)=ADF(z,p)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also    
; ---------------------------------------------------------------------
; Macro       ADF
; ---------------------------------------------------------------------
; Description Calculation of the two tabulated testvalues (the general
;							one is tau) for the Augmented Dickey-Fuller Test of a 
;							unit root in an autoregressive process for with a 
;							constant and no linear trend
; ---------------------------------------------------------------------
; Usage       (rho,tau)=ADF(z,p)
; Input       
; Parameter   y	series to be estimated
; Definition  
; Parameter   p number of included past differences in the regresion
; Definition  
; Output      
; Parameter   rho
; Definition  
; Parameter   tau
; Definition  
; ---------------------------------------------------------------------
; Notes       
; ---------------------------------------------------------------------
; Example     x=normal(1000)
;							x=cumsum(x)
;							{rho,tau}=ADF(x,7)
; ---------------------------------------------------------------------
; Result      Contents of rho
;							[1,]   2.0501
;							Contents of tau
;							[1,]  0.93084
; ---------------------------------------------------------------------
; Keywords    Augmented Dickey-Fuller test, Cointegration, ADF
; ---------------------------------------------------------------------
; Reference   Dickey, D., Fuller, W. "Distribution of the Estimators 
;							for autoregressive Time Series with a unit root" Journal 
;							of the American Statistical Association 74, page 427-431
;							Gourieroux, C., Monfort, A. "Time Series and dynamic
;							Models", Cambridge University Press, 1997 (original in 
;							french 1990 "Sries Temporelles et Modles Dynamiques by 
;							conomica" conomica)
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author     Arne Wuensche 000423 
; ---------------------------------------------------------------------
//
n=rows(z)
i=0
X=matrix(n-p-1,p+2)
while (i<n-p-1)
	i=i+1
	j=0
	while (j<p)
		j=j+1
		X[i,j+2]=z[i+p-j+1]-z[i+p-j]
	endo
endo	
X[,2]=z[(p+1:n-1)]
Y=z[(p+2:n)]
beta=inv(trans(X)*X)*trans(X)*Y
e=Y-X*beta
sigmae=(trans(e)*e)/(n-p-1)
ymean=sum(z[(p+1:n-1)])/(n-p-1)
sumy=trans(z[(p+1:n-1)]-ymean)*(z[(p+1:n-1)]-ymean)
rho=(n-p-1)*(1-beta[2])
tau=(1-beta[2])/sqrt(sigmae/sumy)
endp