proc(erg) = anaabl (et, theta, os, hndl)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also    
; ---------------------------------------------------------------------
; Macro       anaabl
; ---------------------------------------------------------------------
; Description 
; ---------------------------------------------------------------------
; Usage       (erg)=anaabl(et,theta,os,hndl)
; Input       
; Parameter   et
; Definition  
; Parameter   theta
; Definition  
; Parameter   os
; Definition  
; Parameter   hndl
; Definition  
; Output      
; Parameter   erg
; Definition  
; ---------------------------------------------------------------------
; Notes       
; ---------------------------------------------------------------------
; Example     
; ---------------------------------------------------------------------
; Result      
; ---------------------------------------------------------------------
; Keywords    
; ---------------------------------------------------------------------
; Reference   
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Administrator
; ---------------------------------------------------------------------
  
  c0 = (theta[1,]~theta[2,])|(0~theta[3,])
  a = theta[4:5,]~theta[6:7,]
  g = theta[8:9,]~theta[10:11,]
  Avec = (kron(a, a))' 
  
  gvec = (kron(g, g))'
  
  abldet = (2*c0[1,1]~0~0)|(c0[1,2]~c0[1,1]~0)|(c0[1,2]~c0[1,1]~0)|(0~2*c0[1,2]~2*c0[2,2])
  
  dhdc = matrix((rows(et)*4),3)*0
  dhdc[1:4,] = abldet
  dhdc[5:8,] = abldet+gvec*dhdc[1:4,]
  
  dhda = matrix((rows(et)*4),16)*0
  dhdg = matrix((rows(et)*4),16)*0
  
  vecsig = sigma(et,a,g,c0, os, hndl)
  
  hh = (et'*et)/rows(et)
  
  temp = (hh[,1]|hh[,2])'
  
  dhda[1:4,] = kron(temp, unit(4)) 
  dhdg[1:4,] = kron(temp, unit(4)) 
  
  param = list (gvec, abldet, dhdc, dhda, dhdg, vecsig, et, rows(et), rows(gvec) )
  byrow = 0|0|0|0|0|0|0|0|0
  type  = 8|8|8|8|8|8|8|-4|-4
  opt   = list (type, byrow)
  if (os=="windows")
    err = dlcallex(hndl, "_anaabl1", param, opt)
  else
    err = dlcallex(hndl, "anaabl1", param, opt)
  endif    
  error(err==9, "DLL function anaabl1 expects 9 arguments") 		
  error(err==8, "Wrong argument type in DLL function anaabl1, all matrices have to be DBL8")
  error(err==-4, "Wrong argument type in DLL function anaabl1, all scalars have to be INT4")		
  
  dhda=param.dhda
  dhdc=param.dhdc
  dhdg=param.dhdg
  
  dhdc[1:60,] = dhdc[(rows(dhdc)-59):rows(dhdc),]
  
  /* hier liegen vor: Ableitungen fuer das Vecmodell      */
  /* dh_da und dh_dg sind jeweils (T*4 kreuz 16 matrizen) */
  
  /* jetzt werden bestimmt die Ableitungen der vec--Matrizen nach den Bekk--Parmae
  tern */
  
  kommat = unit(4)
  kommat = kommat[1,]|kommat[3,]|kommat[2,]|kommat[4,]
  vecgt = g'
  vecgt = vecgt[,1]|vecgt[,2]
  
  fakg = (kron( kron( unit(2),kommat ),unit(2) ))*(kron(kommat,vecgt)+kron(vecgt,kommat))
  
  vecat = a'
  vecat = vecat[,1]|vecat[,2]
  faka = (kron( kron(unit(2),kommat),unit(2) ))*(kron(kommat,vecat)+kron(vecat,kommat))
  
  dhda = dhda*faka
  dhdg = dhdg*fakg
  
  /* jetzt liegen vor: Ableitungen von vec h nach den paramtern der BEKK notation
  */
  /* Dimension: 4*t kreuz 11 */
  /* in jedem vierblock sind die zweite und dritte zeile identisch */
  /* Nun ist die Ableitung der likelihoodunktion zubestimmen */
  
  /* Bestimmung von dle ln l nach den Elementen von sigma_t */
  
  ablc = matrix(rows(et),3)*0
  abla = matrix(rows(et),4)*0
  ablg = matrix(rows(et),4)*0
  
  param = list (vecsig, dhdc, dhda, dhdg, et, ablc, abla, ablg, rows(et) )
  byrow = 0|0|0|0|0|0|0|0|0
  type  = 8|8|8|8|8|8|8|8|-4
  opt   = list (type, byrow)
  if (os=="windows")
    err = dlcallex(hndl, "_anaabl2", param, opt)
  else
    err = dlcallex(hndl, "anaabl2", param, opt)
  endif
  error(err==9, "DLL function anaabl2 expects 9 arguments.") 		
  error(err==8, "Wrong argument type in DLL function anaabl2, all matrices have to be DBL8.")
  error(err==-4, "Wrong argument type in DLL function anaabl2, all scalars have to be INT4.")
  error(err==10, "Data do not fit to Bigarch algorithm. There exists no inverse in DLL function anaabl2.")
  
  erg = param.ablc~param.abla~param.ablg
  
endp




