proc()=andrewscurv(data)   
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     andrewsrech doista grandrews gruppenvariable istagraphic
;              showd 
; -----------------------------------------------------------------------
; Macro        andrewscurv
; -----------------------------------------------------------------------
; Description  shows andrews curves for the principal components of the
;              selected variables. The number of gridpoints can be chosen
;              be the user and one or more group variables (disctrete type)
;              can be selected. 
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  dcoltype=data.coltype
  ;for group variable only discrete type 
  ;selvar=(1-data.colvar)&&(1-data.coltype)
  coltype=matrix(rows(data.coltype))
  ;for variable selection both types are allowed
  v=50
  vtrs="number of gridpoints"
  ng=readvalue(vtrs, v)
  putglobal("ng")  
  selvar=choosevariable(data,coltype)
  if(sum(selvar).>0)
    {r,c,l,d,titl}=gruppenvariable(data, "andrewsrech",selvar,dcoltype)
    showd(r,c,l,d,titl) 
  endif
endp
    