proc(obj)=andrewsrech(x, gind)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     andrewscurv doista grandrews gruppenvariable istagraphic
; -----------------------------------------------------------------------
; Macro        andrewsrech
; -----------------------------------------------------------------------
; Description  performs a pca on the selected variables and creates a 
;              composed object of the andrews curves of the principal
;         .    components
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  ng=getglobal("ng")
  ;number of gridpoints chosen in andrews.xpl
  if(sum(var(x),1)>0)
  ;no missings in data
    obj = grandrews(transform(x, 4),ng,gind-1)
    ;andrews curves after PCA on data  
  else
    obj="missing(s):"|"no andrews curves possible"
  endif
endp