proc(y) = aseq (x, n, d)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      : mseq
; -----------------------------------------------------------------
;  Keywords      sequence, additive sequence
; -----------------------------------------------------------------
;   Macro        aseq
; -----------------------------------------------------------------
;   Description  Computes an additive sequence.
; -----------------------------------------------------------------
;   Usage        y = aseq (x, n, d)
;   Input
;     Parameter  x  
;     Definition start value
;     Parameter  n
;     Definition length
;     Parameter  d
;     Definition step width
;   Output
;     Parameter  y
;     Definition vector
; -----------------------------------------------------------------
;   Example   library("xplore")
;             aseq (2, 4, 0.1)
; -----------------------------------------------------------------
;   Result
;             Contents of y
;	      [1,]     2 
;	      [2,]   2.1 
;	      [3,]   2.2 
;	      [4,]   2.3 
; -----------------------------------------------------------------
;   Author    TTK, 960207
; -----------------------------------------------------------------

 y = x + (0:n-1)*d

endp