proc(covf)=cfc1diff(hh,covyh,covu,phi,f,di)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     covfore2 
; -----------------------------------------------------------------
;   Macro        cfc1diff
; -----------------------------------------------------------------
;   Description  Forecasting undifferenced time series in VAR models 
; -----------------------------------------------------------------
;   Usage        covf=cfc1diff(hh,covyh,covu,phi,f,di)  
;   Input
;     Parameter   hh
;     Definition      scalar, forecast horizon
;     Parameter   covyh
;     Definition      matrix, covariance matrix of forecasts
;     Parameter   covu
;     Definition      matrix, covariance matrix of residuals
;     Parameter   phi 
;     Definition    scalar, 1.96 for alpha=0.95
;     Parameter   f 
;     Definition    matrix
;     Parameter   di 
;     Definition    scalar, dimension of time series
;   Output
;     Parameter   conf
;     Definition    matrix, forecast intervals
; -----------------------------------------------------------------
;   Author    Christian Hafner 981230
; -----------------------------------------------------------------
covf=zeros(1,di)
fe=eye(di)-f
h=1
while (h<=hh)
  covh=0
  k=1
  while (k<=h)
    i=0
    while (i<=h-k)
       j=0
       while (j<=h-k)
         covh=covh+selec(phi,di,i)*covu*selec(phi,di,j)'
         j=j+1
       endo
       i=i+1
    endo
    k=k+1
  endo
  covf=covf|(f*covh*f'+fe*selec(covyh,di,h-1)*fe')
  h=h+1
endo
covf=covf[2:rows(covf),]
endp;
