proc(elo,eup,hlo,hup)=ciirboot(ahat,uhat,y0,irmax,alpha,nob)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     impres, plotir, varunls, varml
; -----------------------------------------------------------------
;   Macro        ciirboot
; -----------------------------------------------------------------
;   Description  Computes two sided bootstrap confidence intervals for impulse
;                responses for a K-dimensional VAR(p) by resampling
;                the estimated residuals. The confidence intervals
;                are computed using the methodology of Hall (The Bootstrap 
;                and the Edgeworth Expansion, 1992) and Efron & Tibshirani 
;                (An Introduction to the Bootstrap, 1993).
; -----------------------------------------------------------------
;   Usage        {elo,eup,hlo,hup} =  ciirboot(ahat,uhat,y0,irmax,alpha,nob)   
;   Input
;     Parameter   ahat
;     Definition   estimated model parameters            
;     Parameter   uhat
;     Definition   estimated residuals  
;     Parameter   y0
;     Definition   starting values
;     Parameter   irmax
;     Definition   maximum lead for impulse response analysis
;     Parameter   alpha
;     Definition   significance level for confidence intervals
;     Parameter   nob
;     Definition   number of replications for estimating the bootstrap distribution
;   Output                                                           
;     Parameter   elo
;     Definition   lower bounds of "Efron's" confidence intervalls
;     Parameter   eup
;     Definition   upper bounds of "Efron's" confidence intervalls
;     Parameter   hlo
;     Definition   lower bounds of "Hall's" confidence intervalls
;     Parameter   hup
;     Definition   upper bounds of "Hall's" confidence intervalls
; -----------------------------------------------------------------
;   Author Benkwitz 980127
; -----------------------------------------------------------------

;
trend=0
K=rows(uhat)
T=cols(uhat)
p=rint(cols(ahat)/K)
irhat=impres(ahat,irmax)                 ; estimated impulse responses
uhat=uhat-mean(uhat')'
Lboot=zeros(nob,rows(vec(irhat)))        ; bootstrap law
i=1
do
;
  count=i*100/(nob*5)		; show every 5% of progress
   if ( count ==rint(count) )
    Progress=string(" %3.0f", count*5)~"% done!"
    Progress
   endif
;
  ustar=dwithr(uhat)
  y=simvar(ustar,y0,ahat)	
  {astar,ustar,sstar,gstar}=varunls(y,p,trend)
  Lboot[i,]=vec(impres(astar,irmax))'
  i=i+1
until (i>nob)
Lboot=sort(Lboot,0)    ; cdf computing
;
; computing efron's bootstrap ci
;
elo=reshape(Lboot[alpha*nob,],#(irmax+1,K^2))
eup=reshape(Lboot[(1-alpha)*nob,],#(irmax+1,K^2))
;
; computing hall's bootstrap ci
;
Lboot=Lboot-vec(irhat)'
hlo=irhat-reshape(Lboot[(1-alpha)*nob,],#(irmax+1,K^2))
hup=irhat-reshape(Lboot[alpha*nob,],#(irmax+1,K^2))
endp



