proc (re) = cimag (z)
; -----------------------------------------------------------------------
; Library      math  
; -----------------------------------------------------------------------
; See_also     complex creal
; -----------------------------------------------------------------------
; Macro        cimag
; -----------------------------------------------------------------------
; Description  Extracts imaginary part of a complex array 
; -----------------------------------------------------------------------
; Usage        y = cimag (z)
; Input
;   Parameter  y
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  re
;   Definition n x p x d1 x ... x dn array imaginary part of z
; -----------------------------------------------------------------------
; Example      library("math")
;              j = complex (0, 1)
;              cimag(j)
; -----------------------------------------------------------------------
; Result       Contents of re
;              [1,]       1
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970530
; -----------------------------------------------------------------------
  error (comp(z, "re")<1, "creal : No real part in z found")
  error (comp(z, "im")<1, "creal : No imaginary part in z found")
  re = z.im
endp