proc (z) = cinv (x)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     cmatdiv cmatmul
; -----------------------------------------------------------------------
; Macro        cinv
; -----------------------------------------------------------------------
; Description  Complex inverse matrix 
; -----------------------------------------------------------------------
; Usage        z = cinv (x)
; Input
; Input
;   Parameter  x 
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              z = complex (1,1)
;              cinv (z)
; -----------------------------------------------------------------------
; Result       Contents of z.re
; 		         [1,]      0.5 
;              Contents of z.im
; 		         [1,]     -0.5 
; -----------------------------------------------------------------------
; Keywords     complex numbers, linear algebra
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960401, 970529
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "cinv : No real part in x found")
  error (comp(x, "im")<1, "cinv : No imaginary part in x found")
  d = det(x.re)
  if (d != 0)
    d  = inv(x.re)
    re = inv(x.re+x.im*d*x.im)
    im = -d*x.im*re 
  else 
    error (det(x.im)==0,  "cinv : singular matrix") 
    d  = inv(x.im) 
    im = inv(-x.re*d*x.re-x.im) 
    re = -d*x.re*im 
  endif 
  z = list(re,im)
endp 

