proc (z) = complex (re, im)  
; -----------------------------------------------------------------------
; Library      math  
; -----------------------------------------------------------------------
; See_also     creal cimag
; -----------------------------------------------------------------------
; Macro        complex
; -----------------------------------------------------------------------
; Description  Generates a complex array
; -----------------------------------------------------------------------
; Usage        z = complex (re {, im})
; Input
;   Parameter  re
;   Definition n x p x d1 x ... x dn array   real part of x 
;   Parameter  im 
;   Definition n x p x d1 x ... x dn array   imaginary part of x  
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              z = complex (0, 1)
;              z
; -----------------------------------------------------------------------
; Result       //Generates the complex object sqrt(-1)
;              Contents of z.re
;              [1,]        0 
;              Contents of z.im
;              [1,]        1 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970529
; -----------------------------------------------------------------------
  error (exist("re")<>1, "complex : no composed object for real part")
  if (exist("im")<>1)
    im = 0.*(re <= Inf)
  endif
  error (sum(dim(re).<>dim(im)), "complex : dim(re)<>dim(im)")
  z = list (re, im)
endp