proc(output)=confidencey(x,b,MSSRin,y,Vin)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista collinearity confidencb covmatrix descriptivelinreg
;              durbinwatson regressionstatistic
; -----------------------------------------------------------------------
; Macro        confidencey
; -----------------------------------------------------------------------
; Description  computes the 95% confidence intervals for the unstandardized
;              predicted values after regression analysis
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  if(rows(y)<=100)
    alpha=.05
    ind=0.*matrix(cols(x))
    ind[Vin]=1
    x=(paf(x',ind))'
    x=matrix(rows(x))~x
    dim(b)
    dim(y)
    yhat=x*b
    m=x*(inv(x'*x))  
    con=xdiag((MSSRin*m)*x')
    d=rows(x)-rows(b)-1
    t=qft(1-alpha/2,d)
    yl=yhat-t.*con
    yu=yhat+t.*con
    firstline="95% confidence intervals for unstandardized"
    firstline=firstline|"predicted values"
    secondline="-------------------------------------------"
    thirdline="lower bound             upper bound"
    fourthline="-----------------------------------"
    ylstr=string("%11.4f   ",yl)
    ystr=string("y %5.0f   ", 1:(rows(y)))
    yustr=string("%11.4f",yu)
    output=firstline|secondline|thirdline|fourthline|(ylstr+ystr+yustr)
  else
    "Attention: too many cases, not computable within accaptable time"
  endif
endp
