proc(h)=conting(p, q)
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also     measure recode kmeans agglom
; -----------------------------------------------------------------------
; Macro        conting
; -----------------------------------------------------------------------
; Description  crosses two categorical variables (for instance
;              partitions from cluster analysis) and builds up 
;              contingency table
; -----------------------------------------------------------------------
; Usage        h = conting (x, y) 
; Input
;   Parameter  x
;   Definition n x 1  matrix partition of n points into k clusters
;   Parameter  y
;   Definition n x 1  matrix partition of n points into l clusters
; Output
;   Parameter  h
;   Definition k x l  contingency table  
; -----------------------------------------------------------------------
; Example     ; load the library xclust
;             library ("xclust")
;             ; generate x data
;             x = #(1, 1, 1, 3, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3)
;             ; generate y data
;             y = #(2, 2, 2, 3, 1, 1, 3, 3, 3, 3, 3, 2, 2, 3, 2, 2, 1, 1, 1, 2, 1)
;             conting(x, y)  
; -----------------------------------------------------------------------
; Result      Content of object h
;
;             [1,]        0        7        1 
;             [2,]        0        0        5 
;             [3,]        6        1        1 
; -----------------------------------------------------------------------
; Author      Hans-Joachim Mucha, 941111 
;             Sigbert Klinke, 970902
; -----------------------------------------------------------------------
  xb = p~q
  {pb, qb}=bindata(xb, 1|1 ,0.5|0.5)
  pb = paf(pb, qb)
  qb = paf(qb, qb)
  n=rows(pb)
  m=max(pb[,1])+1
  l=max(pb[,2])+1
  i=1
  h=0.*matrix(m, l)
  while(i.<=n)
    j=pb[i,1]+1 
    k=pb[i,2]+1 
    h[j,k]=qb[i,1] 
    i=i+1 
  endo 
endp    