proc (n) = countNaN (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      countNotNumber isInf isNaN isNumber
; -----------------------------------------------------------------
;  Keywords      missing values
; -----------------------------------------------------------------
;   Macro        countNaN
; -----------------------------------------------------------------
;   Description  Counts how many missing values (NaN) are in 
;                an array.
; -----------------------------------------------------------------
;   Usage        n = countNaN (x)
;   Input
;     Parameter  x  
;     Definition array
;   Output
;     Parameter  n
;     Definition number of NaNs (between 0 and prod(dim(x)))
; -----------------------------------------------------------------
;   Example   library("xplore")
;             x = #(0/0, 1/0, -1/0, 1)
;             countNaN (x)
; -----------------------------------------------------------------
;   Result    
;             Contents of n  
;	      [1,]     1 
; -----------------------------------------------------------------
;   Author    TTK, 960424
; -----------------------------------------------------------------

  n = sum (!#(x <= Inf))    ; each number is <= infinity except NaN
endp

