proc (s) = cov (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      corr var
; -----------------------------------------------------------------
;  Keywords      covariance, correlation
; -----------------------------------------------------------------
;   Macro        cov
; -----------------------------------------------------------------
;   Description  Computes the covariance
;                structure of a given array.
; -----------------------------------------------------------------
;   Usage        s = cov (x)
;   Input
;     Parameter  x  
;     Definition array
;   Output
;     Parameter  s  
;     Definition consists of covariance matrices of x
; -----------------------------------------------------------------
;   Example   library("xplore")
;             randomize (0)
;             x = normal (200, 2, 3)
;             cov (x)
; -----------------------------------------------------------------
;   Result
;             Contents of s
;	      [,,1,1,1,1,1,1]
;	      [1,] 0.93696 0.0295402 
;	      [2,] 0.0295402 0.931349 
;	      [,,2,1,1,1,1,1]
;	      [1,] 0.828057 0.0111894 
;	      [2,] 0.0111894 1.11964 
;	      [,,3,1,1,1,1,1]
;	      [1,] 1.05956 0.134594 
;	      [2,] 0.134594 0.990536 
; -----------------------------------------------------------------
;   Author    TTK, 960207
; -----------------------------------------------------------------

  n  = rows (x)
  xm = sum (x) ./ n                ; xm is row vector
  s  = (x'*x - n*xm'*xm) ./ (n-1)

endp

