proc(covc)=covabc(ord,rang,di,tb,te,t,typ,ytt,ew)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     modelrr, estabr, covarr, covbrr, covabrr 
; -----------------------------------------------------------------
;   Macro        covabc
; -----------------------------------------------------------------
;   Description  Covariance matrix of C=A*B, Reduced Rank VAR Model
; -----------------------------------------------------------------
;   Usage        covc=covabc(ord,rang,di,tb,te,t,typ,ytt,ew)  
;   Input
;     Parameter   ord  
;     Definition      integer, order of VAR model
;     Parameter   rang
;     Definition      integer, rank of VAR model    
;     Parameter   di
;     Definition      integer, dimension of time series
;     Parameter   tb 
;     Definition      integer, beginning of sample
;     Parameter   te 
;     Definition      integer, end of sample
;     Parameter   t 
;     Definition      integer, length of sample
;     Parameter   typ
;     Definition      integer, model type
;     Parameter   ytt
;     Definition      matrix, transformed time series
;     Parameter   ew
;     Definition      matrix of eigenvalues 
;   Output
;     Parameter   covc
;     Definition     covariance matrix of C
; -----------------------------------------------------------------
;   Author    TP A1/A2, CH 980408
; -----------------------------------------------------------------
diord=di*ord
ab=estabr(ord,di,di,tb,te,typ,ytt)
a=ab[1:di,]
b=ab[di+1:rows(ab),]'
icovp=t*inv(zmulz(ord,di,tb,te,1,0,typ,ytt))
cova2=zeros(di*rang,1)
covb2=zeros(diord*rang,1)
covab2=cova2
i=1
while (i<=rang)
   cova=zeros(1,di)
   covb=zeros(1,diord)
   covab=covb
   j=1
   while (j<=rang)
      cova=cova | covarr(a,ew,rang,j,i,di)
      covb=covb | covbrr(b,ew,rang,j,i,icovp,diord)
      covab=covab | covabrr(a,b,ew,rang,j,i,di,diord)
      j=j+1
   endo
   cova2=cova2 ~ cova[2:rows(cova),]
    covb2=covb2 ~ covb[2:rows(covb),]
    covab2=covab2 ~ covab[2:rows(covab),]
    i=i+1
endo
cova2  = cova2[,2:cols(cova2)]
covb2  = covb2[,2:cols(covb2)]
covab2 = covab2[,2:cols(covab2)]
covc   = (cova2~covab2) | (covab2'~covb2)
endp;
