proc(covf)=covforec(a,cova,covu,ord,adj,tb,te,h,typ,ytt)
; -----------------------------------------------------------------
;   Library       multi
; -----------------------------------------------------------------
;   See_also      domulti
; -----------------------------------------------------------------
;   Macro         covforec
; -----------------------------------------------------------------
;   Description   calculates the forecast MSE matrix for VAR models
; -----------------------------------------------------------------
;   Usage         covf=covforec(a,cova,covu,ord,adj,tb,te,h,typ,ytt) 
;   Input
;     Parameter   a 
;     Definition    matrix, parameters
;     Parameter   cova 
;     Definition    matrix, covariance matrix of parameters 
;     Parameter   covu 
;     Definition    matrix, covariance matrix of residuals
;     Parameter   ord 
;     Definition    vector, order of series
;     Parameter   adj 
;     Definition     scalar, 1=if adjusted, 0=if not
;     Parameter   tb 
;     Definition    integer, (time) begin 
;     Parameter   te 
;     Definition    integer, (time) end
;     Parameter   h 
;     Definition    integer, forecast horizon
;     Parameter   typ 
;     Definition    integer, indicating the model type
;     Parameter   ytt
;     Definition    vector, the transformed time series
;   Output
;     Parameter   covf
;     Definition     matrix, forecast MSE
; -----------------------------------------------------------------
;   Author    Christian Hafner 981230
; -----------------------------------------------------------------
  di=rows(ytt)
  t=te-tb+1
  if (typ <= 4)
     head = "Std.err. taking into account estimation variability?"
     item = "Yes"
     item = item| "No"
     choice = selectitem(head,item,"single")
     choice = (choice[1]==1) 
  endif;
  abig=aorBgen(a,di,ord,adj,typ)
  jota=jotaAorB(di,ord,adj,typ)
  phi=phigen(abig,jota,h,ord,di,typ)
  covf=sigma1(phi,covu,h);
  if ((adj==1) && (typ<>6))
    covf=covf+covmwgen(covu,abig,ord,di,adj,h,typ)/t
  endif;
  if ((choice==1) && (typ==1))
    gam=zmulz(ord,di,tb,te,adj,0,typ,ytt)/t;
    covf= covf+omegagen(abig,gam,phi,covu,h)/t;
  else
  if (choice==1)
    covf= covf+omerrgen(abig,phi,cova,h,t,ord,di,tb,te,adj,typ,ytt)/t
  endif;
  endif
endp;
