proc (z) = csinh (x)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     ccos ccosh cexp cln csin ctan ctanh csqrt
; -----------------------------------------------------------------------
; Macro        csinh
; -----------------------------------------------------------------------
; Description  Complex sine hyperbolicus
; -----------------------------------------------------------------------
; Usage        z = csinh (x)
; Input
;   Parameter  x
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              csinh (complex (0, 3.1415/2))
; -----------------------------------------------------------------------
; Result       Contents of z.re
; 		         [1,]        0
;              Contents of z.im
; 		         [1,]        1
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960401, 970529
; -----------------------------------------------------------------------
  re = sinh(x.re) .* cos(x.im)
  im = cosh(x.re) .* sin(x.im)
  z  = list(re, im)
endp



