proc(xv, wout, s, dopt) = cvdec(disp, w, u, m, x, y, t, dec, opt, err, res, fs, weidist, vmeth)               
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     ann
; -----------------------------------------------------------------------
; Macro        cvdec
; -----------------------------------------------------------------------
; Description  runs a cross validation over the weight decay
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, Janet Grassmann,  951231; Sigbert Klinke, 961121
; -----------------------------------------------------------------------
  str  = "Min weight decay:"|"Max weight decay:"|"Decay step number (>=1):"|"Number of CV sets:"
  stdpar = 0|0|10|2                           
  do               
    ok     = 1
    stdpar = readvalue(str, stdpar)    
    dmin   = stdpar[1]
    dmax   = stdpar[2]
    step   = stdpar[3]
    fold   = stdpar[4]
    if (dmin<0)
      ok = 0
    endif   
    if (dmax<dmin)
      ok = 0
    endif
    if (step<1)
      ok = 0
    endif
    if (fold<1)
      ok = 0
    endif
  until (ok)               
  d    = grid(dmin , (dmax-dmin)./(step-1), step)               
  {xv, wout, s, dopt} = optdec(disp, w, u, m, x, y, t, dec, opt, err, res, fs, weidist, d, fold, vmeth)
endp               
