proc()=dispbar(d, r, c, x)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grbar plotbar
; -----------------------------------------------------------------------
; Macro        dispbar
; -----------------------------------------------------------------------
; Description  plots a barchart in specified window of a display
; -----------------------------------------------------------------------
; Usage        dispbar(d, r, c, x)
; Input        
;   Parameter  d
;   Definition display
;   Parameter  r
;   Definition scalar
;   Parameter  c
;   Definition scalar
;   Parameter  x
;   Definition text or number vector
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              t  = floor((normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25))
;              d  = createdisplay(1,1)
;              dispbar (d, 1, 1, t)
; -----------------------------------------------------------------------
; Result       shows a barchart
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, bar chart
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 980805
; -----------------------------------------------------------------------
  bp = grbar(x)
  n  = rows(bp.yr)
  i  = 0:(n-1)
  k  = 1+floor(n/11)
  c  = abs(i%k)<1.0e-6
  xr = paf(bp.xr, c)
  i  = paf(i, c)
  t2 = i+0.25~-matrix(rows(i))
  setmaskp(t2,0,0,0)
  setmaskt(t2, xr, 0, 0, 12)
  show(d,r,c, bp, t2)
  setgopt(d,r,c,"yoffset", 0|0)
endp
