proc (gamma) = dpgpgamma (x, k)
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      dpgp dpgpdiag
; -----------------------------------------------------------------
;   Macro         dpgpgamma
; -----------------------------------------------------------------
;   Description   Shape parameter of Drees-Pickands estimator.
; -----------------------------------------------------------------
;   Usage         gamma = dpgpgamma (x, k)
;   Input
;     Parameter   x
;     Definition      vector
;     Parameter   k
;     Definition      scalar, number of upper extremes
;   Output
;     Parameter   gamma
;     Definition      scalar, estimated shape parameter
; -----------------------------------------------------------------
;   Notes	  Internal macro called from dpgp and dpgpdiag
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
  gamma = 0
  mu = 0
  sigma = 0
  if (getenv ("os")=="windows")
    r = dlcall ("_dpgp", x, rows (x), k, gamma, mu, sigma)
  else
    r = dlcall ("dpgp", x, rows (x), k, gamma, mu, sigma)
  endif
  warning (r != 0, "Drees-Pickands (GP) failed")
endp
