proc () = factor(x)
; -----------------------------------------------------------------
; Library      stats
; -----------------------------------------------------------------
; See_also     pca draftman 
; -----------------------------------------------------------------
; Macro        factor
; -----------------------------------------------------------------
; Description  factor performs a Factor Analysis for x (principal
;              component, principal axes). For each method you can 
;              interactively between two different criteria for the
;              factors. At the end you get a draftman plot of the
;              the chosen factors.      
; -----------------------------------------------------------------
; Usage       factor (x)
; Input
;   Parameter  x  
;   Definition n x p matrix
; -----------------------------------------------------------------
; Example   ; loads the library stats
;           library("stats")   
;           ; load library graphic 
;           library("graphic")  
;           ; read swiss banknote data                             
;           x = read("bank2")         
;           ; interactive factor analysis                              
;           factor(x)                             
; -----------------------------------------------------------------
; Result    The program generates two displays. One shows a
;           scatterplot matrix of X. The second shows at the top
;           a parallel coordinate plot of gamma (matrix of the 
;           evec) and at the bottom the communalties and so on.
; -----------------------------------------------------------------
; Author    Katharina Kroel, Kerstin Zanter ,961202  
;           Sigbert Klinke, 970820
; -----------------------------------------------------------------  
  x = (x-mean(x))./(sqrt(var(x)))  
  p = cols(x)
  selhead = "Factor analysis"
  selitem = "Principal component"|"Principal axis"
  end = 0
  do
    sel = selectitem (selhead, selitem)
    end = sum(sel).=0
    if (sel[1])
      r  = cov(x)      
      t  = 1:rows(r)
      id = (t.=t')
      d  = id
      r0 = r-id
      {lambda, gamma} = eigsm(r)         
      c  = lambda~trans(gamma)          
      c  = sort(c, -1)                 
      lambda  = c[,1]
      lambdan = 100*lambda/sum(lambda)
      gamma   = trans(c[,2:cols(c)])
      h    = gamma^2.*lambda'
      a    = cols(x)  
      cums = 100*cumsum(lambda)./sum(lambda)
      hv   = sum(h[,1:a],2)
      f    = 1:a
      q    = gamma*(sqrt(diag(lambda)))
      q    = q*q'
      d    = diag(hv)
      r    = r0+d
; 
      bp   = grpcp(q)
      setsize (700,500)
;  
      di   = createdisplay(2,1)
      show    (di,1,1,bp)
      setgopt (di,1,1 ,"title","Parallel coordinate plot")
      setgopt (di,1,1 ,"xlabel","Factors","ylabel","Variables X_i")
      s0  = "Initial Statistic"
      s1  = "Variable Communality Factor Eigenvalue PctofVar CumPct" 
      s2  = string("X%-2.0f         %6.4f     %2.0f  %10.5f   %5.1f",1:cols(x), hv,f,lambda,lambdan)
      s2  = s2+string("   %5.1f", cums )  
      s   = s0|s1|s2
      show (di,2,1,s)      
      selhead1 = "Criteria for factors"
      selitem1 = "Variance"|"Kaiser"
      l    = 85
      sel1 = selectitem (selhead1, selitem1)
      end  = sum(sel).=0 
      if(sel1[1])
        do
          l = readvalue("Percentage of variance",l)
        until((l<100)&& (l>0))  
        w = cumsum(lambda)./sum(lambda)
        a = sum(w.<(l/100))+1
      endif 
      if (sel1[2])
	a = sum(lambda .>1)
      endif 
 ;
      {lambda, gamma} = eigsm(r)         
      c = lambda~trans(gamma)          
      c = sort(c, -1)                 
      lambda  = c[,1]
      lambdan = 100*lambda/sum(lambda)
      g       = gamma^2
      gamma   = trans(c[,2:cols(c)])
      h       = gamma^2.*lambda'  
      cums    = 100*cumsum(lambda)./sum(lambda)
      hv      = sum(h[,1:a],2)
      f       = 1:a
      d       = diag(hv)
      r       = r0+d
;   
      la      = lambda[1:a,]
      lan     = lambdan[1:a,]
      s0      = "Final Statistic"
      s1      = "Variable Communality Factor Eigenvalue PctofVar CumPct" 
      s2      = string("X%-2.0f         %6.4f     %2.0f  %10.5f   %5.1f",1:a, hv[1:a],f,lambda[1:a],lambdan[1:a])
      s2      = s2+string("   %5.1f", cums)  
      if (a<cols(x))
       s3 = string("X%-2.0f         %6.4f",a+1:cols(x), hv[a+1:cols(x)])
       s  = s0|s1|s2|s3
      else
       s  = s0|s1|s2
      endif
      show (di,2,1,s) 
      fl = gamma[,1:a].*sqrt(lambda[1:a,1].*(lambda[1:a,1].>0))'
      f  = x*fl*inv(fl'*fl)
    endif
    if (sel[2])
     r  = cov(x)
     rm = matrix(p)
     i  = 0
     do
       i = i+1
       if (i.=1)
         r2 = r[2:p,2:p]
         r1 = r[2:p,1]           
       else 
       if (i.=p)
         r2 = r[1:p-1,1:p-1]
         r1 = r[1:p-1,p]
       else
         r2 = r[(1:i-1)|(i+1:p),(1:i-1)|(i+1:p)]
         r1 = r[(1:i-1)|(i+1:p),i]
       endif
       endif
       rm[i]=r1'*inv(r2)*r1 
     until(i>=p) 
     t  = 1:rows(r)
     id = (t.=t')
     d  = id
     r0 = r-id
     {lambda, gamma}=eigsm(r)         
     h    = gamma^2.*lambda'
     a    = cols(x)  
     cums = 100*cumsum(lambda)./sum(lambda)
     hv   = rm
     f    = 1:a
     q    = gamma*(sqrt(diag(lambda)))
     q    = q*q'
     d    = diag(hv)
     r    = r0+d
     lambdas = sort(lambda,-1)
     cums    = 100*cumsum(lambdas)./sum(lambdas)
     lambdan = 100*lambdas/sum(lambdas)
     sumfs   = sum(lambdas)
     bp      = grpcp(q)
     setsize (700,500)
     di = createdisplay(2,1)
     show (di,1,1,bp)
;     
     s0 = "Initial Statistic"
     s1 = "Variable Communality Factor Eigenvalue PctofVar CumPct" 
     s2 = string("X%-2.0f         %6.4f     %2.0f  %10.5f   %5.1f",1:cols(x), hv,f,lambdas,lambdan)
     s2 = s2+string("   %5.1f", cums )  
     s  = s0|s1|s2
     show(di,2,1,s)      
     selhead2 = "Choosing factors"
     selitem2 = "No of factors"|"Kaiser"
     l    = 2
     sel2 = selectitem (selhead2, selitem2)
     if(sel2[1])
       do
         l = readvalue("No of factors",l)
       until((l<10)&& (l>0))  
       w = cumsum(lambda)./sum(lambda)
       a = l
     endif 
     if(sel2[2])
       a = sum(lambda .>1)
     endif
     i = 0
     do
       oldhv = hv
       i     = i+1
       {lambda, gamma}=eigsm(r)         
       h     = gamma^2.*abs(lambda)'   
       hv    = sum(h,2)
       f     = 1:a
       d     = diag(hv)
       r     = r0+d
       s     = sum(hv.>1)
       error(s ,"communality larger one")
     until (sum((oldhv-hv)^2).<1e-6)        
; 
     lambdas = sort(lambda~gamma',-1)
     lambdan = 100*lambdas[,1]/sumfs
     la      = lambdas[1:a,1]
     lan     = lambdan[1:a,]
     cums    = 100*cumsum(lambdas[,1])./sumfs
     s0 = "Final Statistic"
     s1 = "Variable Communality Factor Eigenvalue PctofVar CumPct" 
     s2 = string("X%-2.0f         %6.4f     %2.0f  %10.5f   %5.1f",1:a, hv[1:a],f,lambdas[1:a,1],lambdan[1:a])
     s2 = s2+string("   %5.1f", cums)  
     if (a<cols(x))
       s3 = string("X%-2.0f         %6.4f",a+1:cols(x), hv[a+1:cols(x)])
       s  = s0|s1|s2|s3
     else
       s  = s0|s1|s2
     endif
     show (di,2,1,s) 
     gammaa = lambdas[1:a,2:cols(x)+1]'
     fl     = gammaa.*sqrt(lambdas[1:a,1].*(lambdas[1:a,1].>0))'
     f      = x*fl*inv(fl'*fl)
   endif
 until(end)
 da=createdisplay(a,a)     
 i = 0
 while (i.<a)
   i = i+1
   j = 0
   while (j.<a)
     j=j+1
     if (i>j)
      xx = f[,j]~f[,i]
      show(da,i,j,xx)
     endif
     if (i==j)
      xlab = string("%1.0f.Factor",j) 
      show(da,i,j,xlab)
     endif
   endo   
 endo
endp          
 