proc (five) = fivenum (x,xvars)
; -----------------------------------------------------------------
; Library        stats
; -----------------------------------------------------------------
;  See_also      quantile
; -----------------------------------------------------------------
;   Macro        fivenum
; -----------------------------------------------------------------
;   Description  computes the five number summary consisting of the
;                minimum and maximum, the quartiles and the median. 
; -----------------------------------------------------------------
;   Usage        five = fivenum (x)
;   Input
;     Parameter  x  
;     Definition        array
;     Parameter   xvars
;     Definition        optional, p x 1  string vector, variable names. Note,
;                       that only up to 15 characters are used.
;   Output
;     Parameter  five  
;     Definition        string output, containing five number summary.
; -----------------------------------------------------------------
;   Example   library("stats")
;             setenv("outputstringformat", "%s") 
;             randomize (0)
;             x = normal (200)
;             fivenum (x)
; -----------------------------------------------------------------
;   Result    Contents of five
;             [ 1,] 
;             [ 2,] ================================================== 
;             [ 3,]  Five number summary 
;             [ 4,] -------------------------------------------------- 
;             [ 5,]    Minimum            -2.7801947 
;             [ 6,]    25% Quartile      -0.59753362 
;             [ 7,]    Median           -0.064324884 
;             [ 8,]    75% Quartile       0.54136684 
;             [ 9,]    Maximum             2.4442013 
;             [10,] ================================================== 
;             [11,] 
; -----------------------------------------------------------------
;   Author    TTK, Marlene Mueller, 970903
; -----------------------------------------------------------------
;
 if (exist(x)==9)
    x=x{1}
  endif
  if (exist(xvars)>0)
    error(exist(xvars)!=2,"variable names should be strings!")
    if (cols(xvars)>1)
      xvars=reshape(xvars, cols(xvars)|rows(xvars))
    endif
  endif
;   
  p=cols(x)
;
  error(rows(dim(x))>2,"first argument must be vector or matrix")
  error(exist(x)!=1,"first argument must be numeric")
  if (exist(xvars)>0)
    error(rows(dim(xvars))>1,"variable names have wrong dimension")
    error(rows(xvars)!=p,"variable names have wrong dimension")
    xvars=string(": ",1:p)+xvars
  else
    if (p>1)
      xvars=string(": Variable %1.0f",1:p)
    else
      xvars=""
    endif
  endif
;
  y = quantile (x, (0:4)/4)
;
  five=" "
  j=0
  while (j<p)
    j=j+1
    five=five|"==================================================" 
    five=five|" Five number summary"+xvars[j]
    five=five|"--------------------------------------------------"
    five=five|("   Minimum       "+string("%15.8g",y[1,j]))
    five=five|("   25% Quartile  "+string("%15.8g",y[2,j]))
    five=five|("   Median        "+string("%15.8g",y[3,j]))
    five=five|("   75% Quartile  "+string("%15.8g",y[4,j]))
    five=five|("   Maximum       "+string("%15.8g",y[5,j]))
    five=five|"=================================================="
    five=five|" "
  endo
endp




