 proc () = genvub()

 
; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     repa rqua rtri rtrian runi
; -----------------------------------------------------------------
;   Macro       genvub
; -----------------------------------------------------------------
;   Description genvub computes the volume of unit ball from 
;               dimension 1 up to 15 and put the results as global
; -----------------------------------------------------------------
;   Usage       genvub()
;   Output
;     Parameter  vub  
;     Definition  15 x 1 matrix
; -----------------------------------------------------------------
;   Example   genvub()
;             vub
; -----------------------------------------------------------------
;   Result   Contents of vub 
;  [ 1,]        2 
;  [ 2,]   3.1416 
;  [ 3,]   4.1888 
;  [ 4,]   4.9348 
;  [ 5,]   5.2638 
;  [ 6,]   5.1677 
;  [ 7,]   4.7248 
;  [ 8,]   4.0587 
;  [ 9,]   3.2985 
;  [10,]   2.5502 
;  [11,]   1.8841 
;  [12,]   1.3353 
;  [13,]  0.91063 
;  [14,]  0.59926 
;  [15,]  0.38144 
; -----------------------------------------------------------------
;   Author    Lijian Yang, 951117   
; -----------------------------------------------------------------

 
d = 15
vub = 1:d
  n = 1
  while (n<=d)
  if (floor(n/2) == n/2)
   i = n./2
   x = 1:i
  else
   i = (n-1)./2
   x = (0:i)+0.5
  endif
  vub[n]=pi^i./prod(x,1)
  n = n+1
  endo
  putglobal("vub")  
 
endp
