proc(m,b,bv,const)=gintestpl(code,x,t,y,h,g,opt)
; ----------------------------------------------------------------------------
;   Library      gam
; ----------------------------------------------------------------------------
;   See_also     gintest intest intestpl gamfit gamopt gamout
; ----------------------------------------------------------------------------
;   Macro        gintestpl
; ----------------------------------------------------------------------------
;   Description  gintestpl fits an additive generalized partially linear model
;                E[y|x,t] = G(x*b + m(t)).
;                This macro offers a convenient interface for GPLM estimation.
;                A preparation of data is performed (inclusive sorting).
; ----------------------------------------------------------------------------
;   Link         ../tutorials/gamstart.html Tutorial: GAM in XploRe
; ----------------------------------------------------------------------------
;   Usage        {m,b,bv,const} = gintestpl(code,x,t,y,h,g{,opt})
;   Input
;     Parameter   code
;     Definition        text string, the short code for the model (e.g.
;                       "bilo" for logit or "noid" for ordinary PLM),
;                       see tutorial.
;     Parameter   x
;     Definition        n x d  matrix, the discrete predictor variables.
;     Parameter   t
;     Definition        n x p  matrix, the continuous predictor variables.
;     Parameter   y
;     Definition        n x 1  vector, the response variables.
;     Parameter   h
;     Definition        p x 1  vector or scalar, chosen bandwidth for
;                       the directions of interest.
;     Parameter   g
;     Definition        p x 1  vector or scalar, chosen bandwidth for
;                       the directions not of interest.
;     Parameter   opt
;     Definition        optional, a list with optional input. The macro
;                       "gamopt" can be used to set up this parameter.
;                       The order of the list elements is not important.
;                       Parameters which are not given are replaced by
;                       defaults (see below).
;     Parameter   opt.tg
;     Definition        ng x 1 vector, a grid for continuous part. If tg is
;                       given, the nonparametric function will also be
;                       computed on this grid.
;     Parameter   opt.wx
;     Definition        scalar or n x 1 vector, prior weights. For
;                       binomial models usually the binomial index vector.
;                       If not given, set to 1.
;     Parameter   opt.b0
;     Definition        d x 1  vector, the initial coefficients. If not
;                       given, all coefficients are set to GLM pre-estimation.
;     Parameter   opt.wt
;     Definition        n x 1  vector, weights for t (trimming factors).
;                       If not given, all set to 1.
;     Parameter   opt.shf
;     Definition        integer,  (show-how-far) if exists and =1, an output
;                       is produced which indicates how the iteration
;                       is going on (additive function / point of estimation /
;                       number of iteration).
;     Parameter   opt.nosort
;     Definition        integer, if exists and =1, the continuous variables
;                       t and the grid tg are assumed to be sorted by the
;                       1st column. Sorting is required by the algorithm,
;                       hence you should switch if off only when the data
;                       are already sorted.
;     Parameter   opt.miter
;     Definition        integer, maximal number of iterations. The default
;                       is 10.
;     Parameter   opt.cnv
;     Definition        integer, convergence criterion. The default is 0.0001.
;     Parameter   opt.fscor
;     Definition        integer, if exists and =1, a Fisher scoring is
;                       performed (instead of the default Newton-Raphson
;                       procedure). This parameter is ignored for
;                       canonical links.
;     Parameter   opt.wtc
;     Definition        n x 1  vector, weights for convergence criterion,
;                       w.r.t. m(t) only. If not given, opt.wt is used.
;     Parameter   opt.off
;     Definition        scalar or n x 1 vector, offset. Can be used for
;                       constrained estimation. If not given, set to 0.
;     Parameter   opt.pow
;     Definition        scalar, power for power link. If not given,
;                       set to 0.
;     Parameter   opt.nbk
;     Definition        scalar, extra parameter k for negative binomial
;                       distribution. If not given, set to 1 (geometric
;                       distribution).
;   Output
;     Parameter   m
;     Definition        n x 1  vector, estimated nonparametric part
;     Parameter   b
;     Definition        d x 1  vector, estimated coefficients
;     Parameter   bv
;     Definition        d x d  matrix, estimated covariance matrix for coeff.
;     Parameter   const
;     Definition        ng x 1  vector, estimated nonparametric part on grid
; ----------------------------------------------------------------------------
;   Example   library("gam")
;             randomize(1235)
;             n     = 100
;             p     = 2
;             d     = 2
;             b     = 1|2
;             t     = uniform(n,p)*2-1
;             x     = 2.*uniform(n,d)-1
;             g1    = 2*t[,1]
;             g2    = t[,2]^2
;             g2    = g2 - mean(g2)
;             m     = g1 + g2
;             y     = cdfn(m+x*b) .> uniform(n)    ; probit model
;             h     = #(1.7, 1.5)
;             g     = #(1.7, 1.5)
;             tg    = grid(-0.8,0.1,18)
;             opt   = gamopt("tg",tg~tg)
;             opt   = gamopt("shf",1,opt)
;             code  = "bipro"
;             {m,b,bv,c} = gintestpl(code,x,t,y,h,g,opt)
;             gamout(t,y,m,b,c,gamopt("pl",1,"x",x,"bv",bv,opt))
; ----------------------------------------------------------------------------
;   Result    A generalized partially linear logit fit for E[y|x,t] is
;             computed. sf.b contains the coefficients for the linear
;             part. sf.m contains the estimated nonparametric part
;             evaluated at observations t. The example gives the
;             true b together with the GPLM estimate sf.b. Also, the
;             estimated function sf.m is displayed together with the
;             true fit m. The procedure has been introduced in
;                Haerdle, Huet, Mammen and Sperlich (1997)
; ----------------------------------------------------------------------------
;   Author    Sperlich & Stockmeyer, 970729
; ----------------------------------------------------------------------------
;
; initialize (gplminit)
; -------------------------------------------------------------------
  if (exist(opt)==0)
    dummy=0
    opt=list(dummy)  ; dummy optional parameter, doesn't matter
  endif
  {xs,ts,ys,wx,wt,wtc,b0,m0,off,ctrl,tg,m0g,tro,tgro}=gplminit(code,x,t,y,h,opt)
  n=rows(xs)
  d=cols(xs)
  p=cols(ts)
  if (rows(g)<>p)             /* reshape g to matrix */
    errtext = "rows of g didn't fit: "+string("%1.4f",g[1,1])+" assumed"
    warning(rows(g)>1,errtext)
    g = matrix(p)*g[1,1]
  endif
  if (rows(h)<>p)            /* reshape h to matrix */
    errtext = "rows of h didn't fit: "+string("%1.4f",h[1,1])+" assumed"
    warning(rows(h)>1,errtext)
    h = matrix(p)*h[1,1]
  endif
  m = matrix(n)
  xnew = matrix(n,d)
  ignoreig = 0
  innergrid = (n>50)*(1-ignoreig)
  havegrid = (countNaN(tg)!=prod(dim(tg)))
  glmmodels = getglobal("glmmodels")
  gplmmodels = getglobal("gplmmodels")
  twoparfam = sum(code==(glmmodels.twoparfam)) >0
  binomial = sum(code==(glmmodels.binomial)) >0
  gaussian = sum(code==(glmmodels.gaussian)) >0
  poisson = sum(code==(glmmodels.poisson)) >0
  gamma = sum(code==(glmmodels.gamma))>0
  igaussian = sum(code==(glmmodels.igaussian))>0
  nbinomial = sum(code==(glmmodels.nbinomial))>0
  canonical = sum(code==(glmmodels.canonical)) >0
  power = sum(code==(glmmodels.power)) >0
  direct = 1
  dllon=0
  if (existglobal("dllon")==1)
    dllon=getglobal("dllon")
  endif
  error((1-direct)&&(1-dllon),"dll's are not enabled! dllon=1 not set?")
;
; set defaults
; ---------------------------------------------------------------------
  shf  = (ctrl[1]==1)
  miter= ctrl[2]
  cnv  = ctrl[3]
  fscor= ctrl[4]
  pow  = ctrl[5]*(power)
  nbk  = ctrl[6]*(nbinomial)
  if ((code=="nopow")&&(pow==1))
    code="noid"
    direct=1
    power=0
  endif
  if (power*(pow!=0))
    error(min(min(xs),2)<0,"glmcore: can do only x>=0 with power link")
  endif
;
; GLM pre-estimation
; ---------------------------------------------------------------------
  {bglm,bvdummy,statdummy} = glmest(code,xs~ts~matrix(n),ys)
  const = matrix(n)*bglm[(d+p+1)]
  if (sum(isNaN(b0)||(b0==0))>0)
    b0 = bglm[1:d]
  endif
  m0 = ts*bglm[(d+1):(d+p)]+const
;
; first pre-estimation (b)
; ---------------------------------------------------------------------
  it1=1
  crit=0
  etafunc="gplmeta"+code
  xtildefunc="gplmxtilde"+code
  if (fscor==1)
    etafunc=etafunc+"fs"
    xtildefunc=xtildefunc+"fs"
  endif
  do
    if (shf)
      ("gintestpl: pre-estimation: "+string("%1.0f",it1))
    endif
    xb=xs*b0+off
    if (direct)
      tmp=sker(ts,g',"qua",(wx~(ys[,1]-xb)~xs))
      m=tmp[,2]./tmp[,1]
      xnew=xs-tmp[,3:cols(tmp)]./tmp[,1]
    else
      exec( "notok=dlcall(xtildefunc,n|p|d,xb,(ts/g'),ys[,1],wx,m0,xs,m,xnew)" )
    endif
    if (fscor*(1-canonical))
      {ll1,ll2}=glmlld(code+"fs",xb+m,ys[,1],pow)
    else
      {ll1,ll2}=glmlld(code,xb+m,ys[,1],pow)
    endif
    B = xnew'*(wt.*wx.*ll2.*xnew)
    bv=-inv(B)
    b=b0+bv*sum(wt.*wx.*ll1.*xnew)'
    db=b-b0
    chgb=sqrt( sum(db.*db)./sum(b0.*b0) )
    dm=m-m0
    if (rows(wtc)==n)
      dm=dm.*wtc
      m0=m0.*wtc
    else
      dm=dm.*wt
      m0=m0.*wt
    endif
    chgm=sqrt( sum(dm.*dm)./sum(m0.*m0) )
    crit=((chgb<cnv)+(chgm<cnv)>1)
    it1=it1+1
    b0=b
    m0=m
  until (crit+(it1>miter))
  it1=it1-1
  sel = isNumber(m)
  if (sum(sel)>0)
    const = mean(paf(m,sel))
  endif
;
; second estimation (m)
; -----------------------------------------------------------------------
  if (p>1)
    switch
    case (innergrid)
      nig = (n>499)*40+(n<500)*25+10
      tmin = min(ts)
      tmax = max(ts)
      range = tmax-tmin
      ig = tmin + (0:4)*(0.02*range)
      ig = ig | (tmin+range*0.1) + (0:nig-11)*(0.8*range/(nig-11))
      ig = ig | (tmin+range*23/25) + (0:4)*(0.02*range)
      break
;    case ((ignoreig)&&(havegrid))
    case (havegrid)     ; changed by Jiri Zelinka 2.9.1999
      nig = rows(tg)
      ig = tg
      break
    default
      nig = n
      ig = ts
    endsw
    xb = xs*b0+const
    fh = matrix(nig,p)*0
    j=1
    while (j<=p)
      hg = h
      hg[j] = g[j]
      i=1
      while (i<=nig)
        test = ts
        test[,j] = ig[i,j]*matrix(n,1)
        m0 = test*bglm[(d+1):(d+p)]
        it2=1
        crit=0
        do
          if (shf)
            out = "gintestpl: main estimation : "
            out = out + string("%1.0f",j)+" "+string("%1.0f",i)
            (out +" "+string("%1.0f",it2))
          endif
          if (direct)
            tmp = sker(ts,hg',"qua",(wx~(ys[,1]-xb)),test)
            m = tmp[,2]./tmp[,1]
          else
            exec("notok=dlcall(etafunc,n|p|n,xb,(ts/hg'),ys[,1],wx,test,m0,m)")
          endif
          if (fscor*(1-canonical))
            {ll1,ll2}=glmlld(code+"fs",xb+m,ys[,1],pow)
          else
            {ll1,ll2}=glmlld(code,xb+m,ys[,1],pow)
          endif
          dm=m-m0
          if (rows(wtc)==n)
            dm=dm.*wtc
            m0=m0.*wtc
          else
            dm=dm.*wt
            m0=m0.*wt
          endif
          chgm=sqrt( sum(dm.*dm)./sum(m0.*m0) )
          crit=((chgm<cnv)>0)
          it2=it2+1
          m0=m
        until (crit+(it2>miter))
        it2=it2-1
        if (sum(isNumber(m))>0)
          fh[i,j] = mean(paf(m,isNumber(m)))
        endif
        i=i+1
      endo
      j=j+1
    endo
  endif
;
; use the grid ? / reorder ? / interpolation
; ----------------------------------------------------------------------
  switch
  case (p<2)
    if (countNaN(tro)!=prod(dim(tro)))
      m = m[tro]
    endif
    break
  case (innergrid)
    if (havegrid)
      ng = rows(tg)
      ipol = matrix(ng,p)*0
    else
      ng = n
      ipol = matrix(n,p)*0
      tg = ts
    endif
    j = 1
    while (j<=p)
      ig0 = ig[1:nig-1,j]
      ig1 = ig[2:nig,j]
      s = (tg[,j]>=ig0')&&(tg[,j]<ig1')
      f0 = fh[1:nig-1,j]
      f1 = fh[2:nig,j]
      ipol[,j] = s*f0 + s*((f1-f0)/(ig1-ig0)) .* (tg[,j]-s*ig0)
      upper = (tmax[,j]==tg[,j])
      if (sum(upper)>0)
        ipol[paf((upper.*(1:ng)),upper),j] = fh[nig,j]
      endif
    j = j + 1
    endo
    fh = ipol
  case ((havegrid)&&(countNaN(tgro)!=prod(dim(tgro))))
    m = fh[tgro]
    break
  case (countNaN(tro)!=prod(dim(tro)))
    m = fh[tro]
    break
  default
    m = fh
  endsw
endp
