proc(h) = glmdiagh(bv,x,w)
; -----------------------------------------------------------------
; Library       glm
; -----------------------------------------------------------------
;  See_also     glmest glmstat eigsm
; -----------------------------------------------------------------
;   Macro       glmdiagh
; -----------------------------------------------------------------
;   Description  glmdiagh calculates the diagonal elements of the 
;                'hat' matrix              
; -----------------------------------------------------------------
;   Link  ../tutorials/glmstart.html Tutorial: GLM in XploRe 
; ----------------------------------------------------------------------------
;   Usage        h = glmdiagh(bv,x{,w})
;   Input
;     Parameter   bv  
;     Definition        p x p  matrix, the estimated covariance 
;                       matrix for the coefficients.
;     Parameter   x  
;     Definition        n x p  matrix, the matrix of (observed) 
;                       regressor variables.
;     Parameter   w  
;     Definition        optional, n x 1  matrix, the weights 
;                       used to estimate the coefficients.
;   Output
;     Parameter   h
;     Definition         n x 1  matrix, the diagonal elements of 
;                        the `hat' matrix:
;                             W'^(1/2)X(X'WX)^(-1) X'W^(1/2).
; -----------------------------------------------------------------
;   Example   library("glm")
;             n = 100
;             b = 2|(-1) 
;             x = normal(n,rows(b))
;             m = ceil(uniform(n).*5) 
;             {y,p} = genglm("bilo",x,b,m)
;             opt=glmopt("wx",m)             
;             l = glmest("bilo",x,y,opt)
;             d=glmlld("bilo",x*b,y,opt)
;             h=glmdiagh(l.bv,x, -m.*d.ll2)          
; -----------------------------------------------------------------
;   Result    Vector of diagonal elements of the hat matrix.
; -----------------------------------------------------------------
;   Author    Marlene Mueller, 2000/05/18
; -----------------------------------------------------------------
  {eval,evec}=eigsm(bv)
  h = x*evec.*(sqrt(eval)')
  if (exist(w))  
    h =sqrt(w).*h  
  endif  
  h = sum(h.*h,2)  
endp      






