proc (r) = gpme (gamma, t)
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      empme gp1me
; -----------------------------------------------------------------
;   Macro         gpme
; -----------------------------------------------------------------
;   Description   gpme evaluates the mean excess function of the
;                 GP distribution with shape parameter gamma for
;		  all elements of a vector.
; -----------------------------------------------------------------
;   Usage         r = gpme(gamma, t)
;   Input
;     Parameter   gamma
;     Definition      scalar, shape parameter
;     Parameter   t
;     Definition      vector
;   Output
;     Parameter   r
;     Definition      vector
; -----------------------------------------------------------------
;   Example   library("finance")
;	      gpme(0.5,3)
; -----------------------------------------------------------------
;   Result    Contents of r
;             [1,]        5
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
    sigma = 1
    n = rows (t)
    if (gamma == 0)
        r = matrix (n) * sigma
    else 
        if (gamma < 0)
    	    r = zeros (n, 1)
    	    ind = t > 0 && t < -1 / gamma
    	    if (sum (ind) > 0)
      		i = paf (1:n, ind)
      		r [i] = sigma * (1 + gamma * t [i]) / (1 - gamma)
    	    endif
 	else 
	    if (gamma < 1)
		r = zeros (n, 1)
		ind = t > 0
		if (sum (ind) > 0)
		    i = paf (1:n, ind)
      		    r [i] = sigma * (1 + gamma * t [i]) / (1 - gamma)
    		endif
  	    else 
		error (gamma > 1, "Mean excess function does not exist")
  	    endif
 	endif
    endif
endp
  