proc(d)=gpplot(x, m, k)
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  corrint, distance
; ----------------------------------------------------------------------
;   Macro	  gpplot
; ----------------------------------------------------------------------
;   Description   returns the Grassberger-Procaccia plot 
;                 for time series
; ----------------------------------------------------------------------
;   Reference
;                 Grassberger and  Procaccia (1983), Measuring the 
;                 Strangeness of Strange Attractors, Physica 9D: 189-208
; -----------------------------------------------------------------------
;   Usage         d = gpplot(x,m,k)
; -----------------------------------------------------------------------
;   Input 
;     Parameter   x
;     Definition  vector
;     Parameter   m 
;     Definition  positive integer < 10 (embedding dimension)
;     Parameter   k
;     Definition  positive integer (number of shuffles)
;   Output
;     Parameter   d
;     Definition  display 
; ----------------------------------------------------------------------
;   Example       library("times")
;                 x=normal(100)
;                 d=gpplot(x,2,10)
; ----------------------------------------------------------------------
;   Result
;                 GP plot of independent white noise
; ----------------------------------------------------------------------
;   Author        Christian Hafner, 980130
; ----------------------------------------------------------------------
  error(m>10, "The embedding dimension m must be smaller than 11")  
  error(cols(x)<>1, "The number of columns of X must be equal to one")  
  gporg=corrint(x, m)         ; corr. integral of original series  
  gp=matrix(101, k) 
  i=1 
  while(i<=k) 
    t=ceil(uniform(rows(x), 1).*rows(x))  ; index matrix for shuffling
    y=index(x, t)                     ; obtain i'th bootstrap 
    y=y.*sqrt(var(x)/var(y))          ; adjust standard deviation 
    c = corrint(y,m)
    gp[,i]=c[,2] 
    i=i+1 
  endo 
  th = aseq(1,rows(gporg),1)
  gporg=setmask(gporg,"empty","thick","line","solid")
  setmaskl(gporg,th',2,1,5)
  d=createdisplay(1,1) 	
  show(d,1,1,gporg) 
  gptit = string ("GP-Plot (dim=%.0f)", m)
  setgopt(d,1,1,"title", gptit, "xlabel","log eps")
  setgopt(d,1,1,"ylabel","log correlation integral")
  gpmax=gporg[,1]~(max(gp'))'         ; maximum bound of bootstrap 
  gpmin=gporg[,1]~(min(gp'))'         ; minimum bound of bootstrap 
  gpmin=setmask(gpmin,"empty","thick","line","dashed")
  setmaskl(gpmin,th',4,3,3)
  gpmax=setmask(gpmax,"empty","thick","line","dashed")
  setmaskl(gpmax,th',4,3,3)
  adddata(d,1,1,gpmin) 
  adddata(d,1,1,gpmax) 
endp 
