proc (bp)=grbar(x, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grbox grdot grhist grdotd grash
; -----------------------------------------------------------------------
; Macro        grbar
; -----------------------------------------------------------------------
; Description  Generates a barchart.
; -----------------------------------------------------------------------
; Usage        bp = grbar (x {, col})
; Input
;   Parameter  x
;   Definition n x 1      number or text vector
;   Parameter  col
;   Definition color
; Output
;   Parameter  bp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              t  = floor((normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25))
;              bp = grbar (t)
;              plot (bp)
; -----------------------------------------------------------------------
; Result       shows a barchart
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, bar chart
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925,980805
; -----------------------------------------------------------------------
  error (cols(x).<>1, "grbar : cols(x).<>1")
  if (exist("col").<>1)
    grc = getglobal ("grc")  
    col = grc.col.black
  endif
  {xr,yr} = discrete(x) 
  if (exist(xr)==1)
    xr = string ("%g", xr)
  endif
  n = rows(xr)
  i = 0:(n-1)
  x = i|i|(i+0.5)|(i+0.5)
  y = matrix(n)*0
  y = y|yr|yr|y
  bp = x~y
  l = (i~(i+n)~(i+2*n)~(i+3*n)~i)+1
  setmaskp(bp,0,0,0)
  setmaskl(bp,l,0,1,0)
  append(bp, xr)
  append(bp, yr)
endp
