proc(grbin)=grbinomial(n, p, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     pdfbin cdfbin randbin
; -----------------------------------------------------------------------
; Macro        grbinomial
; -----------------------------------------------------------------------
; Description  generates a graphical object which represents the 
;              probability function of a binomial distribution B(n,p)
; -----------------------------------------------------------------------
; Usage        grbin = grbinomial (n, p {, col})
; Input        
;   Parameter  n
;   Definition scalar parameter of binomial distribution
;   Parameter  p
;   Definition scalar parameter of binomial distribution
;   Parameter  col
;   Definition color vector
; Output       
;   Parameter  grbin
;   Definition graphical object
; -----------------------------------------------------------------------
; Example      ; load the library graphic
;              library ("graphic")
;              ; generate a graph of B(3, 0.5)
;              gr = grbinomial (3, 0.5)
;              plot (gr)
; -----------------------------------------------------------------------
; Result       shows the binomial prob func for B(3, 0.5)
; -----------------------------------------------------------------------
; Author       SK, WH, 981231
; -----------------------------------------------------------------------
  if (exist(col)<>1)
    col=0
  endif
  i  = 0:n
  h  = pdfbin(n,p,i)				// pdf of B(n,p)
  grbin = (i-1/3)|(i-1/3)|(i+1/3)|(i+1/3)	// generate bars
  grbin = grbin~((0*i)|h|h|(0*i))		
  lt = 1+(i~(n+1+i)~(2*n+2+i)~(3*n+3+i)~i)	
  setmaskp(grbin, 0, 0, 0)			// get rid of point structure
  setmaskl(grbin, lt, col, 1, 0)
endp
