proc(b) = grbiplot(x,r,k)
; ----------------------------------------------------------------------
; Library 	  graphic
; ----------------------------------------------------------------------
;  See_also	  svd grandrews grpcp grstar grsurface
; ----------------------------------------------------------------------
;   Macro	  grbiplot
; ----------------------------------------------------------------------
;   Description   Generates a graphical object containing the 
;		  coordinates for the biplot of a given matrix.  
; ----------------------------------------------------------------------
;   Usage         y = grbiplot(x,r,k)
;   Input 
;     Parameter   x 
;     Definition  n x p matrix (n >= p) (n cases, p variables)	  
;     Parameter   r 
;     Definition  number, rank of approximation (d <= p)
;     Parameter   k 
;     Definition  number, 0 <= k <= 1
;   Output
;     Parameter   b
;     Definition  n+p x d matrix, containing the coordinates for the 
;		  biplot 
; ----------------------------------------------------------------------
;   Notes	  A biplot is a graphical representation of a data set 
;		  x, where the columns of x represent the variables 
;		  and the rows represent the cases.
;		  For a biplot the matrix x is decomposed, so that
;		  approximatly holds x = a*b' 
;		  where:
;		    a = u_1 * l_1^k ~ u_2 * l_2^k ~ ... ~u_r * l_r^k
;		    b = v_1 * l_1^(1-k) ~ v_2 * l_2^(1-k) ~ 
;		        ... ~v_r * l_r^(1-k)
;		    u_i = left Eigenvectors of x
;		    v_i = right Eigenvectors of x
;		    l_i	= Eigenvalues of x
;		    with: 0<=k<=1 and r<=p
;		  r is known as the rank of approximation.
;		  The vectors in the rows of a are used to plot the
;		  coordinates of the n cases, and the rows of b are 
;		  the coordinates for plotting the p variables.		  
;		  x must be a  n x p  matrix 
; ----------------------------------------------------------------------
;   Example       ; loads the library graphic
;                 library("graphic")
;                 ; reset the random generator
;		  randomize(0)
;                 ; generate a normal distributed dataset with
;                 ; 5 rows and 3 columns
;                 x = normal(5,3)
;                 ; produce a biplot in 2-space
;		  b = grbiplot(x, 2, 0.5)
;                 ; create a display with one window
;                 d = createdisplay(1,1)
;                 ; show the biplot in a display
;		  show(d,1,1,b)
; ----------------------------------------------------------------------
;   Result
;	shows a biplot
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; ----------------------------------------------------------------------
; Keywords    graphic primitives, biplot
; -----------------------------------------------------------------------
;   Author 	Torsten Kleinow, 961209
; ----------------------------------------------------------------------
  {u,l,v} = svd(x)
  if (exist("r")!=1) 
 	r=2		      ;rank of approximation
  endif
;
  a=(l^(k)).*(u')
  b=(l^(1-k)).*(v')
  a=a[1:r,]'
  b=b[1:r,]'
;
  b=a|b
  setmaskp(b,0,11,4)
;
endp
