proc()=hazregtest()
; -----------------------------------------------------------------------
; Library      hazreg
; -----------------------------------------------------------------------
; See_also     hazregmain
; -----------------------------------------------------------------------
; Macro        hazregtest
; -----------------------------------------------------------------------
; Description  Tests the quantlets of the hazreg library.
; -----------------------------------------------------------------------
; Usage        hazregtest()         
; -----------------------------------------------------------------------
; Author       Lijian Yang, 990721
; -----------------------------------------------------------------------

library("hazreg") 
          dat=read("haz.dat")  
          y = dat[,1]                       ; survival time
          c = dat[,2]                       ; censoring variable
          z = dat[,3:4]                     ; covariates
            
            t = min(y~c,2)                  ; censored time             
            delta = (y<=c)                  ; censoring indicator            

            
         {data,ties} = hazdat(t,delta, z)   ; preparing data
       
         t=createdisplay(2,2)
 
             {cil,kme,ciu} = hazkpm(data)
             show(t,1,1,cil,kme,ciu)        ; Kaplan-Meier estimates
                                            ; with Greenwood confidence
                                            ; bounds plotted
        
             {betahat,betak,ck} = hazbeta(data)
             {bhaz,bsurv} = hazbase(data)   
             show(t, 2, 1, bhaz)            ; plot baseline hazard
             show(t,1, 2, bsurv)            ; plot baseline survival
       
            z1 = 1.1|1.23
            surv = hazsurv(data, z1)
            show(t, 2, 2, surv)             ; plot conditional survival

         index = 1|0                        ; testing if the second
                                            ; coefficient is zero

         {val,df,pval} = haztest(data, index)

         val~pval                           ; test statistics and 
                                            ; p-values for the 
                                            ; likelihood ratio, Wald's
                                            ; and scores tests.   

   endp