proc(y)=hinesplot(x, p, q,hines,sel)
; -----------------------------------------------------------------------
; Library      stats
; -----------------------------------------------------------------
; See_also     twboxcox boxcox boxcoxdens
; -----------------------------------------------------------------------
; Macro        hinesplot
; -----------------------------------------------------------------------
; Description  computes the Hines & Hines plot for a fixed p and a set
;              of quantiles. 
; -----------------------------------------------------------------------
; Usage        hinesplot(x, p, q, hines, sel)
; Input
;   Parameter  x
;   Definition n x q 
;   Parameter  p
;   Definition scalar   transformation parameter
;   Parameter  q
;   Definition m x 1    quantiles (<0.5)
;   Parameter  hines
;   Definition display  of size (1,2)
;   Parameter  sel
;   Definition text     "new" if you want to start a new plot, otherwise
;                       "old"
; -----------------------------------------------------------------------
; Example      ; loads the library stats
;              library("stats")   
;              ; loads the library graphic
;              library("graphic")   
;              ; reset random generator 
;              randomize(0)
;              ; generate x
;              x = normal(200)
;              x = x.*x
;              ; create a display
;              t = createdisplay(1,2)
;              ; find interactively a best transformation
;              hinesplot (x, 1, 0.25, t, "new")
; -----------------------------------------------------------------------
; Result       returns the data transformed by interactive choice of p 
; -----------------------------------------------------------------------
; Author       Michaela Dranganska, Ulrich Dorazelski, 951002,
;              Susanne Hannappel, 970220 
;              Sigbert Klinke, 970820, 990424
; ----------------------------------------------------------------------
  if (sel=="new")
    naseq = 51                        
    a   = aseq(0, naseq, 1./(naseq-1))                        
    a   = a[2:(rows(a)-1)]                        
    b   = matrix(rows(a),1)                        
    b   = (2-a^p )^(-1./p )                        
;------------------------------
; QUANTILE   
;------------------------------
    med = quantile(x,(0.5))     
    ql  = quantile(x, q)     
    qh  = quantile(x,(1-q))    
    aq  = ql./med     
    bq  = med./qh 
    aqbq=aq~bq   
; =========     
; output    
; =========  
    POWER     = p
    QUANTILES = q
    POWER
    QUANTILES   
;------------------------------
; DISPLAY  
;------------------------------
    aamatrix = a~a
    setmaskp (aamatrix,7,0,4)
    setmaskl (aamatrix,(1:rows(aamatrix ))',0,1,1)
    show (hines,1,2,aamatrix )
    setheadline (hines,1,2,"which p do you like best ?")
    xlab = "x(q) / x(0.5)"
    ylab = "x(0.5) / x(q-1)"
    setgopt (hines,1,2,"xlabel",xlab,"ylabel",ylab )
    labelp = aamatrix[1,1]~aamatrix[1,2]
    setmaskp (labelp,7,0,4)
    text = "log(x)" 
    setmaskt (labelp,text,1,3,15)
    adddata (hines,1,2,labelp)
    j = 1
    while (j<=rows(p))
      abmatrix = a~b[,j]
      setmaskp (abmatrix,7,0,4)
      setmaskl (abmatrix,(1:rows(abmatrix ))',0,1,1)
      adddata (hines,1,2,abmatrix)
      labelp = abmatrix[1,1]~abmatrix[1,2]
      setmaskp (labelp,7,0,4)
      text = string(" p =%.2f", p)
      setmaskt (labelp,text,1,3,15)
      adddata (hines,1,2,labelp)
      j = j+1
    endo
;----------------------------
;DISPLAY OF DATA
;----------------------------
    setmaskp (aqbq,4,8,5)
    setmaskl (aqbq,(1:rows(aqbq))',4,1,2)
    adddata (hines,1,2,aqbq)
    l= ceil(rows(aqbq)/2)
    labelp = aqbq[l,1]~aqbq[l,2]
    setmaskp (labelp,7,0,4)
    text = "your quantiles"
    setmaskt (labelp,text,4,9,15)
    adddata (hines,1,2,labelp)
  else 
;========================
;a plot already exists, new curves are added
;========================
    naseq = 51                        
    a = aseq(0, naseq, 1./(naseq-1))                        
    a = a[2:(rows(a)-1)]                        
    b = matrix(rows(a),1)                        
    b = (2-a^p )^(-1./p )   
  
    aamatrix = a~a
    setmaskp (aamatrix,0,0,4)
    setmaskl (aamatrix,(1:rows(aamatrix ))',0,1,1)
    adddata (hines,1,2,aamatrix )
    j = 1
    while (j<=rows(p))
      abmatrix = a~b[,j]
      setmaskp (abmatrix,0,0,4)
      setmaskl (abmatrix,(1:rows(abmatrix ))',0,1,1)
      adddata (hines,1,2,abmatrix)
      labelp = abmatrix[1,1]~abmatrix[1,2]
      setmaskp (labelp,7,0,4)
      text   = string(" p =%.2f", p)
      setmaskt (labelp,text,1,3,15)
      adddata (hines,1,2,labelp)
      j = j+1
    endo
  endif
endp
