proc(iaf)=impres(a,t)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     plotir, ciirboot
; -----------------------------------------------------------------
;   Macro        impres
; -----------------------------------------------------------------
;   Description  Computes the forecast error impulse responses of a K-dimensional 
;                VAR(p)-model
;                from the model parameters 'a' up to 't' time periods after the
;                shock.
;
; -----------------------------------------------------------------
;   Usage        iaf =  impres(a,t)   
;   Input
;     Parameter   a 
;     Definition   (KxK*p)-matrix of model parameters            
;     Parameter   t
;     Definition   scalar, time horizon for impulse response analysis
;   Output                                                           
;     Parameter   iaf
;     Definition   (t+1xK^2)-matrix of forecast error impulse responses
; -----------------------------------------------------------------
;   Author Benkwitz 980127
; -----------------------------------------------------------------
;
    error(t<0,"ERROR: time step must be non-negative integer")
    p=rint(cols(a)/rows(a))
    K=rows(a)
    if (p>1);
        a=a|(eye(K*(p-1))~zeros(K*(p-1),K))
    endif
    iaf=zeros(t,K^2) ; ImpulsAntwortFolge 
    i=1
    while (i<=t)
        ia=power(a,i)
        iaf[i,]=vec(ia[1:K,1:K]')'
    	i=i+1
    endo
    iaf=vec(eye(K))'|iaf
endp