proc(testt)=intertest2(t,y,h,g,opt,file)
; -----------------------------------------------------------------
; Library     gam
; -----------------------------------------------------------------
;  See_also       intest, intest2d, interact, intertest1
; -----------------------------------------------------------------
;   Macro         intertest2
; -----------------------------------------------------------------
;   Description   intertest2 is testing for interaction of x_1 and
;                 x_2 in an additive regression model.
;                 It is looking at the estimate of the mixed derivative
;                 of the joint influence and using wild bootstrap.
;                 For details see Sperlich, Tjostheim, Yang (1997)
; -----------------------------------------------------------------
;   Usage         testt = intertest2(t,y,h,g{,opt{,file}})
;   Input
;     Parameter   t
;     Definition      n x p matrix , the observed explanatory variable
;                     where the directions of interest have to be the
;                     first and second column
;     Parameter   y
;     Definition      n x 1 vector , the observed
;                     response variables
;     Parameter   h
;     Definition      2 x 1 or 1 x 1 matrix , chosen bandwidth for
;                     the directions of interest in the estimation step
;     Parameter   g
;     Definition      p x 1 or 1 x 1 matrix , chosen bandwidth for
;                     the directions not of interest in the estimation step
;     Parameter   opt.hyp
;     Definition      pp x 2 matrix, in the rows have to be all pairs
;                     of indices for interactions which shall be included
;                     in the hypothesis model. Thus (1,2) must not be
;                     a row of hyp.
;     Parameter   opt.boot
;     Definition      integer, number of bootstrap replications, default=249.
;     Parameter   opt.hb
;     Definition      scalar, bandwidth multiplicator for the bootstrap
;                     step. When the test statistics are calculated with
;                     estimating the derivative we take bandwidths h*hb
;                     and g*hb instead of h, g. Default is 1.
;     Parameter   opt.weight
;     Definition      n x 1 vector, weights for the test statistics.
;                     Default is weight 1 for all.
;     Parameter   opt.loc
;     Definition      integer from {1,2}, degree for the local polynomial
;                     smoother, default is linear (loc=1)
;     Parameter   file
;     Definition      string, file name of output, if an output of
;                     the function estimates is wished
;   Output
;     Parameter   testt
;     Definition     string object, a table of results
; -----------------------------------------------------------------
;   Example   library("gam")
;             randomize(12345)
;             n     = 50
;             t     = uniform(n,3)*2-1
;             g1    = 2*t[,1]
;             g2    = t[,2]^2 - mean(t[,2]^2)
;             g3    = sin(3*t[,3])
;             g12   = t[,1].*t[,2]
;             y     = g1+g2+g3+g12+normal(n)*sqrt(0.5)
;             h     = #(1.1,1.0,0.9)
;             g     = #(1.2,1.2,1.1)
;             boot  = 99
;             hb    = 1.5
;             weight= matrix(n)-prod((abs(t[,1:2]).>0.85),2)
;             opt   = list(boot,hb,weight)
;             intertest2(t,y,h,g,opt)
; -----------------------------------------------------------------
;   Result    table of test results
; -----------------------------------------------------------------
;   Author    Sperlich   970724
; -----------------------------------------------------------------
 p = cols(t)
 n = rows(t)
 wei = matrix(n)
 if (comp("opt","weight")>0)
    wei = opt.weight
 endif
 nboot = 249
 if (comp("opt","boot")>0)
    nboot = opt.boot
 endif
 pp = 0
 if (comp("opt","hyp")>0)
    hyp = opt.hyp
    pp  = rows(hyp)
 endif
 o = sort(t[,1]~(1:n))[,2]
 ro = sort(o~(1:n))[,2]
 ys = y[o]
 ts = t[o]
 if (rows(g)<>p)             /* reshape g to matrix */
   errtext = "rows of g didn't fit: "+string("%1.4f",g[1,1])+" assumed"
   warning(rows(g)>1,errtext)
   g = matrix(p)*g[1,1]
 endif
 if (rows(h)<>p)            /* reshape h to matrix */
   errtext = "rows of h didn't fit: "+string("%1.4f",h[1,1])+" assumed"
   warning(rows(h)>1,errtext)
   h = matrix(p)*h[1,1]
 endif
;
; inner grid
; -----------------------------------------------------------------
 innergrid = (n>40)
 if (innergrid)
   nig = (n>499)*40+(n<500)*25+10
   tmin = min(t)
   tmax = max(t)
   range = tmax-tmin
   ig = tmin + (0:4)*(0.02*range)
   ig = ig | (tmin+range*0.1) + (0:nig-11)*(0.8*range/(nig-11))
   ig = ig | (tmin+range*23/25) + (0:4)*(0.02*range)
 else
   nig = n
   ig = t
 endif
 fhig = matrix(nig,p)*0
 fh = matrix(n,p+pp+1)*0
;
; estimation routine
; -----------------------------------------------------------------
if (exist(hyp))
   incl = hyp|(1~2)
else
   incl = 1~2
endif
 if (comp("opt","loc")>0)
    loc = opt.loc
 else
    loc = 1
 endif
{fh,c} = interact(t,y,h,g,loc,incl)
 mhco = sum(fh,2)
 sel = isNumber(mhco)
 co   = mean(paf((y-mhco),sel))
 mh   = mhco.+co
 eps  = y-mh
if (exist(file))
   write(fh,file)
endif
;
;   Wild Bootstrap, Golden Cut
;---------------------------------
perc = matrix(5)
 nb1 = nboot+1
p1  = floor(nb1 * 0.99)
p5  = floor(nb1 * 0.95)
p10 = floor(nb1 * 0.90)
p15 = floor(nb1 * 0.85)
p20 = floor(nb1 * 0.80)
  aa = (1-sqrt(5))/2
  bb = (1+sqrt(5))/2
  cc = (5+sqrt(5))/10

  mult = uniform(n,nboot)
  mult = aa*(mult.<cc) + bb*(mult.>=cc)
  beps = (mult .* eps)
  yb   = sum(fh[,1:(p+pp)],2)+co+ beps
  yb   = yb~y
  yb   = yb[o,]

 fhb = matrix(n,1,nb1)*0 ;
if (comp("opt","hb")>0)
  h = h * opt.hb
  g = g * opt.hb
endif
  if (p>2)
     hs = g
     hs[1:2] = h[1:2]
     m = 1
     while (m.<=n)
       test = ts
       test[,1:2] = t[m,1:2].*matrix(n)
       ma = locpol(ts,test,yb,hs,1)
         sel = isNumber(ma[,1,1])
         if (sum(sel,1)<>n)
           ma = paf(ma,sel)
         endif
         fhb[m,1,] = mean(ma[,(1+p+2),],1)
       m = m+1
     endo
  else
      fhb[,1,] = locpol(ts,ts,yb,h,1)[ro,(1+p+2),]
  endif
 bstat = reshape(sum((fhb[,1,]^2.*wei),1),#(nb1,1,1))
 Rstat = bstat[nb1,1]

rrs = sort(bstat,1)
perc[1] = Rstat >= rrs[p1]
perc[2] = Rstat >= rrs[p5]
perc[3] = Rstat >= rrs[p10]
perc[4] = Rstat >= rrs[p15]
perc[5] = Rstat >= rrs[p20]
phi = sum(perc)>0.1
crit= rrs[p1]|rrs[p5]|rrs[p10]|rrs[p15]|rrs[p20]
 if (exist(file))
   text1 =("function estimates has been written in ")+file
 else
   text1 ="no output of function estimates"
 endif
 text2 ="HYPOTHESIS: There is no interaction of x_1,x_2"
 text2 = text2 | " " | "  testing for the mixed derivative  "
 text2 = text2 | ("  Number of bootstrap replications: "+string("%4.0f",nboot))
 if (phi)
   text3 ="Hypothesis has been rejected"
 else
   text3 ="Hypothesis has not been rejected"
 endif
 vec1 = (" niveau ")+(" rejected ")+("   crit.value   ")
 vec1 = vec1+("   test stat.  ")
 hline ="-------------------------------------------------------"
 hlined="- - - - - - - - - - - - - - - - - - - - - - - - - - - -"
 mat = string("%5.0f",( 1| 5|10|15|20)) + string("%10.0f",perc)
 mat = mat + string("%16.5f",crit)
  Rstat = Rstat*matrix(5)
 mat = mat + string("%15.5f",Rstat)
 testt = " "|hlined|text1|" "|text2|" "|text3
 testt = testt|" "|hline|hline|vec1|hlined
 testt = testt|mat|hline|hline|" "
endp
