proc(A,V,ctrl) = iteras(A0,S1,S2,b,N,eps,itmax,expl)

; -----------------------------------------------------------------
; Library        kalman
; -----------------------------------------------------------------
;  See_also      rICfil, calibrIC, ICerzsep
; -----------------------------------------------------------------
;   Macro        iteras
; -----------------------------------------------------------------
;   Description  Auxiliary routine for rICfil:
;
;                - if possible - solves for 
;                Lambda1~N(0,S1),Lambda2~N(0,S2) indep.
;
;                A^{-1} =E [ Lambda1 Lambda1' w_b ] + E [ Lambda2 Lambda2' ]   (1)
;
;                w_b=min(1,b/|A Lambda1|)
;
;                using a fixed-point-algorithm
; -----------------------------------------------------------------
;   Keywords     robust Kalman filter, rIC
; -----------------------------------------------------------------
;   Usage          {A,V,ctrl}=iteras(A0,S1,S2,b,N,eps,itmax,expl)
;   Input
;     Parameter   A0  
;     Definition     p x p; starting value for A; if 0 is entered I^{-1} is taken
;                                 if p>1 and dim(A0)==1 I^{-1}*A0 is taken
;     Parameter   S1
;     Definition     p x p; Covariance of the first (clipped) component
;     Parameter   S2
;     Definition     p x p; Covariance of the second (unclipped) component
;     Parameter   b    
;     Definition     numeric; clipping height
;     Parameter    N
;     Definition      integer; MC-sample size / integration grid-points
;     Parameter    eps
;     Definition      numeric; exactitude
;     Parameter    itmax
;     Definition      integer; maximal number of iterastions
;     Parameter    expl
;     Definition      numeric; threshold for the changes in abs. value of A: 
;                        beyond this value convergence is uncertain  ~ 4
; Output                                                           
;     Parameter   A
;     Definition     p x p;  Lagrange-Multiplyer solving (1)
;     Parameter   V
;     Definition     p x p;  corresponding Covariance
;     Parameter   ctrl
;     Definition     integer; tells if convergence "happened"
; -----------------------------------------------------------------
; Notes
; Not to be used outside of rICfil!
; 
; Is called by ICerzsep.
;
; Calles [within kalman.lib]  numint2m stointpm. 
; -----------------------------------------------------------------
;   Example   to be looked up in rICfil
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991010 
; -----------------------------------------------------------------
  
p=rows(S1)

FI=S1+S2

if ((rows(S1)>1)&&(dim(A0)==1))
   A=ginv(FI)*abs(A0)
endif


if (A0==0)
   A=ginv(FI)
else
   A=A0
endif

S1s=svd(S1)

S1w=S1s.u*(sqrt(S1s.l).*S1s.v')

aS1=A*S1
aS1w=A*S1w
i=0
del1=eps+1
del2=expl-1
del3=1
norm=max(abs(vec(A)))

while((del1>eps)&&(i<itmax)&&(del2<expl)&&(del3<expl^2))
   altA=A
   norm0=norm
   
   if (p==2)
       erg=numint2m(aS1w,b,N)
   endif
   if (p>2)
       erg=stointpm(aS1w,b,N)
   endif
   aI=S1w*(erg.r)*S1w+S2
   A=ginv(aI)
   aS1w=A*S1w

   i=i+1
   norm=max(abs(vec(A)))
   del1=sum(vec(abs(A-altA)))
   del2=norm/norm0
   del3=del3*del2
endo

ctrl=((del3>expl^2)||(del2>expl))+2*(i>itmax)

V=A*(S1w*(erg.s)*S1w+S2)*A

endp
