proc(X,Y)=kemitor2(T,x0,H,F,ErrY,ErrX)

; -----------------------------------------------------------------
; Library        kalman
; -----------------------------------------------------------------
;  See_also      kfilter, ksmoother, kem, kemitor, epscontnorm
; -----------------------------------------------------------------
;   Macro        kemitor2
; -----------------------------------------------------------------
;   Description  Simulates observations and states of a 
;                     given state-space-model  - just as kemitor 
;                     by Petr Franek (quantlib times) - but this time also the 
;                     states are returned.
;                     The state-space model is assumed to be
;                     in the following form:
;
;                y_t = H x_t + ErrY_t
;
;                x_t = F x_t-1 + ErrX_t
;
;                x_0 = mu
;
; -----------------------------------------------------------------
;   Keywords     state-space models
; -----------------------------------------------------------------
;   Usage         {X,Y} = kemitor2(T,mu,H,F,ErrY,ErrX)    
;   Input
;     Parameter   T   
;     Definition      number of observations to be generated
;     Parameter   mu
;     Definition      n x 1 vector (starting point of the model)
;     Parameter   H    
;     Definition      m x n matrix
;     Parameter   F    
;     Definition      n x n matrix
;     Parameter   ErrY   
;     Definition      T x m matrix of errors
;     Parameter   ErrX
;     Definition      T x n matrix of errors 
;   Output                                                           
;     Parameter   X  
;     Definition      T x n matrix of generated states, 
;                     T is the number of generated states,
;                     n is the dimension of generated states
;     Parameter   Y  
;     Definition      T x m matrix of generated time series, 
;                     T is the number of generated observations,
;                     m is the dimension of generated time series
; -----------------------------------------------------------------
;   Example   library("plot")
;             library("kalman")
;c.f. original kemitor by P.Franek for more examples
;             randomize(0)
;             T = 100
;             mu=0
;             H = 1
;             F = 1
;             mid=0
;             Cid=1
;             mcont=10
;             Ccont=0.1
;             eps=0.1
;             ErrX = normal(T)
;             ErrY = epscontnorm(T,eps,mid,Cid,mcont,Ccont,0)
;             sim = kemitor2(T,mu,H,F,ErrY,ErrX)
;             state = (1:100)~(sim.X)
;             obs= (1:100)~(sim.Y)
;             ind = (ErrY.Ind)
;             ind=ind/ind*0 ;           sets all "0" to missing and all "1" to 0 
;             ind = (1:100)~ind
;             setmaskp(ind,4, 3, 8)  ;       on all contam. instances a red flag is plotted
;             state=setmask(state,"line","blue","thin")          
;             obs=setmask(obs,"line","green","thin")          
;             disp = createdisplay(1,1)
;             show(disp,1,1,state,obs,ind)
;             setgopt(disp,1,1, "title", "State Space Model (1 - dim steady state) under AO")
; -----------------------------------------------------------------
;   Result    Generates a simulation of length 100 of a steady state model (i.e. H=R=Q=F=1)
;                under a convex contaminated ErrY (AO) [radius=0.1, K=N(10,0.1)]
; -----------------------------------------------------------------
;   Example   library("plot")
;             library("kalman")
;c.f. original kemitor by P.Franek for more examples
;             randomize(0)
;             T = 100
;             mu=0
;             H = 1
;             F = 1
;             mid=0
;             Cid=1
;             mcont=10
;             Ccont=0.1
;             eps=0.1
;             ErrY = normal(T)
;             ErrX = epscontnorm(T,eps,mid,Cid,mcont,Ccont,0)
;             sim = kemitor2(T,mu,H,F,ErrY,ErrX)
;             state = (1:100)~(sim.X)
;             obs= (1:100)~(sim.Y)
;             ind = (ErrX.Ind)
;             ind=ind/ind*0 ;           sets all "0" to missing and all "1" to 0 
;             ind=(1:100)~ind
;             setmaskp(ind,4, 3, 8)  ;       on all contam. instances a red flag is plotted
;             state=setmask(state,"line","blue","thin")          
;             obs=setmask(obs,"line","green","thin")          
;             disp = createdisplay(1,1)
;             show(disp,1,1,state,obs,ind)
;             setgopt(disp,1,1, "title", "State Space Model (1 - dim steady state) under IO")
; -----------------------------------------------------------------
;   Result    Generates a simulation of length 100 of a steady state model (i.e. H=R=Q=F=1)
;                under a convex contaminated ErrX (IO) [radius=0.1, K=N(10,0.1)]
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991018
; -----------------------------------------------------------------

; dimensions check
  
  error(cols(F) <> rows(F), "Matrix F is not square.")
  error(cols(F) <> rows(x0), "Matrix F and x0 dim mismatch.")
  error(cols(H)<>rows(x0),"Matrix H and x0 dim mismatch.")
  error(cols(ErrX)<>rows(x0),"x-errors and x0 dim mismatch.")
  error(rows(H)<>cols(ErrY),"Matrix H and y-errors dim mismatch.")
  warning(rows(ErrX) <> rows(ErrY), "Different number of x- and y-errors.")
  warning(rows(ErrX) <> T, "Number of x-errors different from number of observations.")
  warning(rows(ErrY) <> T, "Number of y-errors different from number of observations.")


  PomX = F * x0   + ErrX[1,]'
  PomY = H * PomX + ErrY[1,]'          ; starting x and y 
  
  Y = PomY                   ; resulting serie [obs]
  X= PomX                     ; resulting serie [states]
  i = 2
  PrevPomX = PomX
  while (i <= T)
    PomX = F * PrevPomX + ErrX[i,]'
    PomY = H * PomX     + ErrY[i,]'
    PrevPomX = PomX
    Y = Y~PomY  
    X = X~PomX  
    i = i+1
  endo
  X=X'
  Y = Y'
  
endp
