proc(y)=leafnum(tree,node)
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also    cartsplit, cartsplitopt, cartcv, maketr,  pred,
;             prederr, prune, prunecv, pruneseq, prunetot, ssr, kuva
; -----------------------------------------------------------------------
; Macro        leafnum
; -----------------------------------------------------------------------
; Description  Gives the number of leaves (terminal nodes) in a
;              regression tree.
; -----------------------------------------------------------------------
; Usage         ln = leafnum(cs, node)
; Input        
;   Parameter  cs
;   Definition  list of vectors: data structure which represents a binary tree
;               and is produced by cartsplit procedure, contains vectors 
;               cs.val, cs.vec, cs.mean, cs.ssr, cs.nelem.
;               See cartsplit for the description of cs.
;   Parameter  node
;   Definition  integer >= 1: gives the index of the root node of
;               the subtree whose number of leaves will be calculated.
;               If node=1, the number of leaves in the hole tree is
;               calculated, if node=2, the number of leaves in the
;               left subtree is calculated, if node=3, the number
;               of leaves in the left subtree of the left subtree
;               (if it exists) is calculated. See cartsplit for
;               the explanation how the tree is represented as a
;               vector. 
; Output       
;   Parameter  ln
;   Definition  integer >= 1: number of leaves in the specified
;               subtree.
; -----------------------------------------------------------------------
; Example      ; loads the library xclust
;              library ("xclust")
; ;let us generate a tree by cartsplit procedure
; x1=#(0,0,0,0,1,1,1,1,1,2)
; x2=#(0,0,0,0,0,0,0,1,1,1)
; x=x1~x2
; y=#(0,0,0,0,100,100,100,120,120,120)
; cs=cartsplit(x,y,#(0,1))
; cs
; ln1=leafnum(cs,1)
; ln1
; ln2=leafnum(cs,2)
; ln2
; ln3=leafnum(cs,3)
; ln3
; -----------------------------------------------------------------------
; Result  
; Content of object cs.val.split0
; [1,] 0 
; [2,] 1,2 
; Content of object cs.val.split1
; [1,] NaN 
; Content of object cs.val.split2
; [1,] 0 
; Content of object cs.val.split3
; [1,] NaN 
; Content of object cs.val.split4
; [1,] NaN 
; Content of object cs.vec
; [1,] 1.000000 
; [2,] NaN 
; [3,] 2.000000 
; [4,] NaN 
; [5,] NaN 
; Content of object cs.mean
; [1,] 66.000000 
; [2,] 0.000000 
; [3,] 110.000000 
; [4,] 100.000000 
; [5,] 120.000000 
; Content of object cs.var
; [1,] 29640.000000 
; [2,] 0.000000 
; [3,] 600.000000 
; [4,] 0.000000 
; [5,] 0.000000 
; Content of object cs.nelem
; [1,] 10.000000 
; [2,] 4.000000 
; [3,] 6.000000 
; [4,] 3.000000 
; [5,] 3.000000 
; 
; Content of object ln1
; [1,] 3.000000
; Content of object ln2
; [1,] 1.000000
; Content of object ln3
; [1,] 2.000000
; -----------------------------------------------------------------------
; Author       Jussi Klemelae, 980323         
; -----------------------------------------------------------------------
leaf=NaN
ln=0
epoint=endpoint(tree,node)
t=node
while (t <= epoint)
if (tree.vec[t]==leaf)
ln=ln+1
endif
t=t+1
endo
y=ln
endp
