proc(y)=maketr(tree,node)
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also     cartsplit, cartsplitopt, cartcv, leafnum, pred,
;              prederr, prune, prunecv, pruneseq, prunetot, ssr, kuva
; -----------------------------------------------------------------------
; Macro        maketr
; -----------------------------------------------------------------------
; Description  Returns a specified subtree of the given regression tree.
; -----------------------------------------------------------------------
; Usage         subcs = maketr(cs, node)
; Input        
;   Parameter  cs
;   Definition  list of vectors: data structure which represents a binary tree
;               and is produced by cartsplit procedure, contains vectors 
;               cs.val, cs.vec, cs.mean, cs.ssr, cs.nelem.
;               See cartsplit for the description of cs.
;   Parameter   node
;   Definition  integer >= 1: specifies a node of the tree cs.
;               The branch growing from this node will be pruned away. 
;               If node=1, only the root node will be returned,
;               if node=2, the tree will be pruned below the left
;               child of the root node, if node=3, the tree will be
;               pruned below the left subtree of the left subtree
;               (if it exists). See cartsplit for
;               the explanation how the tree is represented as a vector. 
; Output       
;   Parameter  subcs
;   Definition  list of vectors: data structure which represents a binary tree
;               and is produced by cartsplit procedure, contains vectors 
;               subcs.val, subcs.vec,subcs.mean, subcs.ssr, subcs.nelem.
;               See cartsplit for the description of subcs.
;               The tree subcs is the result when the leaves of cs, 
;               which are below the position specified by the argument
;               "node", are cutted away.
; -----------------------------------------------------------------------
; Example      ; load the library xclust
;              library ("xclust")
; ;let us generate a tree by cartsplit procedure
; x1=#(0,0,0,0,1,1,1,1,1,2)
; x2=#(0,0,0,0,0,0,0,1,1,1)
; x=x1~x2
; y=#(0,0,0,0,100,100,100,120,120,120)
; cs=cartsplit(x,y,#(0,1))
; cs
; subcs=maketr(cs,3)
; subcs
; -----------------------------------------------------------------------
; Result
; Content of object cs.val.split0
; [1,] 0 
; [2,] 1,2 
; Content of object cs.val.split1
; [1,] NaN 
; Content of object cs.val.split2
; [1,] 0 
; Content of object cs.val.split3
; [1,] NaN 
; Content of object cs.val.split4
; [1,] NaN 
; Content of object cs.vec
; [1,] 1.000000 
; [2,] NaN 
; [3,] 2.000000 
; [4,] NaN 
; [5,] NaN 
; Contents of cs.mean
; [1,] 66.000000 
; [2,] 0.000000 
; [3,] 110.000000 
; [4,] 100.000000 
; [5,] 120.000000 
; Contents of cs.ssr
; [1,] 29640.000000 
; [2,] 0.000000 
; [3,] 600.000000 
; [4,] 0.000000 
; [5,] 0.000000 
; Contents of cs.nelem
; [1,] 10.000000 
; [2,] 4.000000 
; [3,] 6.000000 
; [4,] 3.000000 
; [5,] 3.000000 
; 
; Contents of subcs.val.split0
; [1,] 0 
; [2,] 1,2 
; Contents of subcs.val.split1
; [1,] NaN 
; Contents of subcs.val.split2
; [1,] NaN 
; Contents of subcs.vec
; [1,] 1.000000 
; [2,] NaN 
; [3,] NaN 
; Contents of subcs.mean
; [1,] 66.000000 
; [2,] 0.000000 
; [3,] 110.000000 
; Contents of subcs.ssr
; [1,] 29640.000000 
; [2,] 0.000000 
; [3,] 600.000000 
; Contents of subcs.nelem
; [1,] 10.000000 
; [2,] 4.000000 
; [3,] 6.000000 
; -----------------------------------------------------------------------
; Author       Jussi Klemelae, 980323         
; -----------------------------------------------------------------------
leaf="NaN"
ep=endpoint(tree,node)
lt=dim(tree.vec)
newlt=lt-(ep-node+1)+1
if (node==1) 
 val=leaf
 vec=matrix(1,1)
 mean=vec
 ssr=vec
 nelem=vec
 tr=list(val,vec,mean,ssr,nelem)
;tr.val[node]=leaf
 tr.vec[node]=NaN
 tr.mean[node]=tree.mean[node]
 tr.ssr[node]=tree.ssr[node]
 tr.nelem[node]=tree.nelem[node]
 y=tr
else
tr=tree
l=tr.val
l{node}=leaf
tr.val=l
tr.vec[node]=NaN
i=node
while  (i < newlt)
i=i+1
l=tr.val
l{i}=tree.val{i+ep-node}
tr.val=l
tr.vec[i]=tree.vec[i+ep-node]
tr.mean[i]=tree.mean[i+ep-node]
tr.ssr[i]=tree.ssr[i+ep-node]
tr.nelem[i]=tree.nelem[i+ep-node]
endo
i=lt
while (i>newlt)
  delete(tr.val,i)
  i=i-1
endo
tr.vec=tr.vec[1:newlt]
tr.mean=tr.mean[1:newlt]
tr.ssr=tr.ssr[1:newlt]
tr.nelem=tr.nelem[1:newlt]
y=tr
endif
endp
