proc (gamma, mu, sigma) = mleev (x)
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      mleev0 lrseev
; -----------------------------------------------------------------
;   Macro         mleev
; -----------------------------------------------------------------
;   Description   Maximum likelihood estimator for EV model
; -----------------------------------------------------------------
;   Usage         {gamma, mu, sigma} = mleev (x)
;   Input
;     Parameter   x
;     Definition      vector
;   Output
;     Parameter   gamma
;     Definition      scalar, estimated shape parameter
;     Parameter   mu
;     Definition      scalar, estimated location parameter
;     Parameter   sigma
;     Definition      scalar, estimated scale parameter	    
; -----------------------------------------------------------------
;   Example   library("finance")
;             randomize(0)
;	            x=randx("ev",100,1)
;             m=mleev(x)
;             m
; -----------------------------------------------------------------
;   Result    Contents of m.gamma
;             [1,]  0.071478
;	            Contents of m.mu
;	            [1,]  -12.021
;             Contents of m.sigma
;             [1,]   34.671 
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
    gamma = 0
    mu = 0
    sigma = 0
    if (getenv ("os")=="windows")
        r = dlcall ("_mleev", x, rows (x), gamma, mu, sigma)
    else
        r = dlcall ("mleev", x, rows (x), gamma, mu, sigma)
    endif
    warning (r != 0, "MLE(EV) failed")
endp
