proc (r) = momentgpdiag (x, k) 
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      momentgp
; -----------------------------------------------------------------
;   Macro         momentgpdiag
; -----------------------------------------------------------------
;   Description   Vector of moment estimator for GP model.
; -----------------------------------------------------------------
;   Usage         r = momentgpdiag (x, k)
;   Input
;     Parameter   x
;     Definition      vector
;     Parameter   k
;     Definition      vector, number of exceedances
;   Output
;     Parameter   r
;     Definition      vector with shape parameters
; -----------------------------------------------------------------
;   Example   library("finance")
;	      x=randx("gp",100,1)
;             r=momentgpdiag(x,3:100)
; -----------------------------------------------------------------
;   Result    Vector with estimated shape parameter for all number of
;             extremes provided in k
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
  n = rows (x)
  error (n < 3, "Data set must have at least 3 elements")
  m = rows (k)
  i = 1
  while (i <= m)
    error (k [i] < 3 || k [i] > n, "Invalid number of extremes (3 <= k <= n)")
    if (i == 1)
      r = momentgp (x, k [i])
    else
      r = r | momentgp (x, k [i])
    endif
    i = i + 1
  endo
endp  