proc(data)=neuronal(datain,x,y)   
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     comittee, nnrnet, nnrpredict, nnrinfo
; -----------------------------------------------------------------------
; Macro        neuronal
; -----------------------------------------------------------------------
; Description   This macro computes different networks of the form single
;               layer feedforward perceptron. The macro can be used alone 
;               or in connection with the library ISTA. The standalone version
;               also needs the parameter data. Just choose 0 for the input.
;               It is possible to split the data in a training and a test set. 
;               The weight for the cases for the training of the net can be
;               chosen, the numbers of hidden units with ``from, stepwidth,
;               to'' and additional information concerning the weights of
;               the units.   Different optional parameters can be chosen to 
;               build the architektur of the network. The choice holds for
;               every single net. The default values are chosen in
;               order to solve a linear regression problem. The optional
;               parameters constits of 8 values. Boolean values for linear
;               output, entropy error function, log probability models and
;               for skip connections (direkt links). The fifth values is
;               the maximum value for the starting weights, the sixth is the 
;               weight decay, the seventh the maximum number of iterations
;               and the the last value generates the output concerning the 
;               architekur of the net if it is equal to one.
;               The output consits of the Error and MSE of the different nets
;               (MSE for test and trainings data separately if chosen) and 
;               the R^2.             
;----------------------------------------------------------------------
; Usage        proc(data)=neuronal(datain,x,y)   
; Input
;   Parameter  x 
;   Definition n x p x d1 x ... x dn array    
;   Parameter  y 
;   Definition n x 1 array  
;   Parameter  datain 
;   Definition for use in ISTA: n x p x d1 x ... x dn array   
;              otherwise:       0    
; Output
;   Parameter  data
;   Definition for use in ISTA: n x p x d1 x ... x dn array   
;              otherwise: 0
; -----------------------------------------------------------------------
; Example      library("nn")
;              datain=0
;              z=read("bostonh")
;              x=z[,1:13]
;              y=z[,14]
;              neuronal(datain,x,y)  
; -----------------------------------------------------------------------
;  Result      Choose for the number of units in hidden layer 3, 1, 7, for the
;              weight decay 0.01 with 500 iterations and one for the output.
;              The architektur of the last network consists of:
;              
;              A 13 - 7 - 1 network: 
;              # weights     : 106 
;              linear output : yes 
;              error function: least squares 
;              log prob model: no 
;              skip links    : no 
;              max. weight   : 0.70 
;              decay         : 0.01 
;              max. Iterat   : 500 
;
; Hidden Units  Error (train)  MSE (train)  MSE (test)  MSE (total)     R^2 
; _________________________________________________________________________ 
;            3      3645.1017      14.8117     25.6890      20.5083  0.7571 
;            4      1392.2963       5.4750     15.6698      10.8141  0.8719 
;            5      1390.0372       5.5051     20.0409      13.1177  0.8446 
;            6      3880.2401      15.9997     23.4849      19.9198  0.7640 
;            7      2285.1690       9.3947     16.6129      13.1750  0.8439 
;
;-----------------------------------------------------------------------
; Keywords     nnfunc nninit nnrdovm nnrsetnet nnrsettrain nnrtest nnvisu
;              nnpredict nninfo committee
;-----------------------------------------------------------------------
; Author       Kerstin Zanter   980331
; ----------------------------------------------------------------------
; Reference    Venables, W. N. and Ripley, B. D. (1994),
;              Modern Applied Statistics with S-Plus, p. 261-266
;
;              Bishop, C. M. (1995),
;              neuronal Networks for Pattern Recognition
; ----------------------------------------------------------------------
  data=datain
  selhead="Neuronal nets"
  selitem="Split data in training/test set"|"Do not split data"
  sel=selectitem(selhead,selitem,"single")
  if(sel[1])
    pstr="percentage of data in trainings set?"
    ps=50
    p=readvalue(pstr,ps)
    t=uniform(rows(x))
    p=p/100
    xt=paf(x,t.>p)
    xv=paf(x,t.<=p)
    yt=paf(y,t.>p)
    yv=paf(y,t.<=p)
  endif
  if(sel[2])
    xt=x ; nesessary for weights
    xv=0
    yt=0
    yv=0   
  endif  
  if(exist(xt)) ;otherwise no x, y chosen
  selheadt="Neuronal nets: options"
    selitemt="Weights for training cases in E"|"Number of units in Hidden layer"
    selitemt=selitemt|"additional parameters"|"additional information"
    selt=selectitem(selheadt,selitemt)
    if(selt[1])
      w=matrix(rows(xt))
      if(rows(w)<15)
        do
          i=0
          while(i<rows(xt))
            i=i+1
            if(i==1)
              wstr=string("Weight for case %2.f",i)
            else
              wstr=wstr|string("Weight for case %2.f",i)
            endif
          endo      
          weights=readvalue(wstr,w)
        until(sum(weights)>0)
      else
       weights=matrix(rows(xt))
       "More than 15 cases: choice not possible!"
      endif
    else
      weights=matrix(rows(xt))
    endif 
    if(selt[2])
      hstr="start number of hidden units"|"stepwidth"|"maximum number of hidden units"
      s=floor(sqrt(cols(xt)+cols(y)))
      h=s|1|3*s
      s=readvalue(hstr,h) 
      if(sum(h>3))
        if(s[2]==1)
          size=grid(s[1],s[2],floor((s[3]/s[2]))-1)
        else
          size=grid(s[1],s[2],floor((s[3]/s[2])))
        endif
        else
          size=floor(sqrt(cols(xt)+cols(y)))
        endif 
      else
         size=1
      endif
      if(selt[3])
      pstr="Linear output units"|"Entropy error function"|"Log prob model"
      pstr=pstr|"Direct links"|"Normal random for weights [-rang, +rang]"
      pstr=pstr|"Weight decay"|"Maximum number of iterations"|"Output"
      p=1|0|0|0|0.7|0|100|1
      par=readvalue(pstr,p)
      if(sum(par[1]&&par[2]))
        warning="Entropy error fit only for logistic units (classification)"
        warning
        do
          pstr1="Linear output units"|"Entropy error function"
          p1=0|0
          par[1:2]=readvalue(pstr1,p1)
        until(sum(par[1:2])<=1)
       endif
       if(sum(par[3]))
         par[1]=1
         par[2]=0
       endif
    else
      par=1|0|0|0|0.7|0|100|0
    endif    
    if(selt[4])
      predict=1
    else
      predict=0
    endif
    i=0
    rs=rows(size)
    yh=matrix(rows(y),rs)
    e=matrix(rs)
;with splitting data  
    if(sum(yt)) ;does training data exist?
      rt=rows(yt)
      rv=rows(xv)
      yhv=matrix(rv,rs)
      yht=matrix(rt,rs) 
      while(i<rs)
        i=i+1
        net=nnrnet(xt,yt,weights,size[i],par) 
        if(sum(predict))
          nnrinfo(net)
        endif
        yht[,i]=net.yh
        e[i]=net.value
        yhv[,i]=nnrpredict(xv,net)
        yh[,i]=nnrpredict(x,net)
      endo
      mseyht=sum((yht-yt)^2)/rt
      mseyhv=sum((yhv-yv)^2)/rv
      mseyh=sum((yh-y)^2)/rows(y)
      SSE=sum((yh-y)^2)
      SST=sum((y-mean(y))^2)
      mi=minind(mseyhv')
      Rsquare=1-(SSE/SST)
      Rstr=string("%5.4f",Rsquare')
      firstline="Hidden Units  Error (train)  MSE (train)  "
      firstline=firstline+"MSE (test)  MSE (total)     R^2"
      secondline="------------------------------------------"
      secondline=secondline+"-------------------------------"
      sstr=string("%12.f  ",size)
      mseyhtstr=string("%11.4f  ",mseyht')
      mseyhvstr=string("%10.4f  ",mseyhv')
      mseyhstr=string("%11.4f  ",mseyh')
      estr=string("%13.4f  ",e)
      thirdline=sstr+estr+mseyhtstr+mseyhvstr+mseyhstr+Rstr
      out=firstline|secondline|thirdline
      out
;without splitting data
    else
      yht=matrix(rows(y),rs)
      while(i<rs)
        i=i+1
        net=nnrnet(x,y,weights,size[i],par) 
        yh[,i]=net.yh
        e[,i]=net.value
        if(sum(predict))
          nnrinfo(net)
        endif
      endo  
      mseyh=sum((yh-y)^2)/rows(y)
      SST=sum((y-mean(y))^2)
      SSE=sum((yh-y)^2)
      Rsquare=1-(SSE/SST)
      Rstr=string("%5.4f",Rsquare')
      mi=minind(mseyh')  
      firstline="Hidden Units  Error (total)  MSE (total)     R^2"
      secondline="------------------------------------------------"
      sstr=string("%12.f  ",size)
      mseyhstr=string("%11.3f  ",mseyh')
      estr=string("%13.3f  ",e)
      thirdline=sstr+estr+mseyhstr+Rstr
      out=firstline|secondline|thirdline
      out
    endif
    yh=yh[,mi] 
    MSSRin=mseyh[,mi] 
    if(sum(data))
      selheads="Save new Variables?"
      selitems="Yes"|"No"
      sels=selectitem(selheads,selitems,"single")
      if(sels[1])  
        Vin=1:cols(x)
        b=0
        yhat=yh
        cmd = "data=regressionsave(data,x,y,MSSRin,b,Vin,yhat)"
        exec(cmd)
      endif                                              
      if(sels[2])
      endif
    endif
endif
endp