proc(w,u,m)=nnlayer(v, vn)   
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     ann
; -----------------------------------------------------------------------
; Macro        nnlayer
; -----------------------------------------------------------------------
; Description  builds a feedforward network
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, Janet Grassmann,  951231; Sigbert Klinke, 961121
; -----------------------------------------------------------------------
  r  = rows(v)          
  error(cols(v).<>2, "NNLAYER : Two columns required")               
  error(r.<2, "NNLAYER : Two layers required")               
  u  = x3matrix(v[1,1], 2,(-1)~v[1,2]) 
;  mt = vn[1:v[1,1],]               
  ;m  = vtocc(x3matrix(v[1,1], 1, 110))               
  m = x3matrix(v[1,1], 1, 2)              
  i  = 2               
  sv = cumsum(1|v[,1])               
  nl = "A"|"B"|"C"|"D"|"E"|"F"|"G"|"H"|"I"|"J"|"K"|"L"|"M"|"N"|"O"|"P"|"Q"|"R"|"S"|"T"|"U"|"V"|"W"|"X"|"Y"|"Z"              
  while (i.<r)               
    l = v[i,1]               
    u = u|(x3matrix(l, 2, (0~v[i,2]))) 
;    mt = mt|(nl[i-1,1]+string("%.0f", (1:l)))          
    ;m = m|vtocc(x3matrix(l, 1, 47-i))               
    m = m|x3matrix(l, 1, 2+i)               
    x = sv[i-1,1]|sv[i,1]               
    n = v[i-1,1]|l               
    g = grid(x, matrix(rows(x)), n)               
    if (i.=2)               
      w = g               
    else               
      w = w|g               
    endif               
    i = i+1               
  endo          
  u = u|(x3matrix(v[r,1], 2, (1~v[r,2]))) 
;  mt = mt|vn[(v[1,1]+1):rows(vn),]
  ;m = m|vtocc(x3matrix(v[r,1], 1, 95))  
  m = m|x3matrix(v[r,1], 1, 3)              
  x = sv[r-1,1]|sv[r,1]               
  n = v[r-1,1]|v[r,1]            
  g = grid(x, matrix(rows(x)), n)               
  if (i.=2)               
    w = g               
  else               
    w = w|g               
  endif 
endp               
