proc(net)=nnrload(name)
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     nnrnet ann nnrpredict nnrsave
; ----------------------------------------------------------------------
; Macro        nnrload
; -----------------------------------------------------------------------
; Description  loads a network from different files
; -----------------------------------------------------------------------
; Usage        net = nnrload(name)
; Input
;   Parameter  name
;   Definition name of a file (without extension)
; Output
;   Parameter  net
;   Definition composed object from nnrnet
; -----------------------------------------------------------------------
; Example     x = read("kredit1")
;             t = read("tkredit")
;             y = x[,1]
;             x = x[,2:21]
;             x = (x-min(x))./(max(x)-min(x))
;             net = nnrsave ("nnkred")
;             yh = nnrpredict (net, x)
; -----------------------------------------------------------------------
; Result      loads a net from the files nnkred.xxx and computes a
;             prediction
; -----------------------------------------------------------------------
; Author      Sigbert Klinke, 970603
; -----------------------------------------------------------------------
  v       = read (name+ ".nng")
  n       = v[1:3]
  decay   = v[4]
  entropy = v[5]
  softmax = v[6]
  value   = v[7]
  nunits  = read (name + ".nnn")
  nsunits = read (name + ".nnu")
  nconn   = read (name + ".nnc")
  conn    = read (name + ".nno")
  wts     = read (name + ".nnw")
  net     = list(n, nunits, nsunits, nconn, conn, decay, entropy, softmax, value, wts)
endp
