proc(y)=omgenci(yp,c,ord,dy,b,e,t,di);
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  modelci
; ----------------------------------------------------------------------
;   Macro	  omgenci
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for cointegration
; ----------------------------------------------------------------------
;   Usage         y= omgenci(yp,c,ord,dy,b,e,t,di)
;   Input 
;     Parameter   yp 
;     Definition     matrix, submatrix of time series
;     Parameter   c 
;     Definition     matrix 
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   dy 
;     Definition     matrix, differenced time series
;     Parameter   b 
;     Definition     matrix 
;     Parameter   e 
;     Definition     vector 
;     Parameter   t 
;     Definition     vector, number of observations
;     Parameter   di 
;     Definition     integer, dimension of time series
;   Output
;     Parameter   y
;     Definition     matrix 
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Stefan Sperlich 971215
; ---------------------------------------------------------------------- 
  om=c*yzci(dy,yp,ord,b,e,di);
  om=(zzgenci(dy,ord,b,e,di)|om)~(om'|c*yp*yp'*c');
  y=om/t
endp;
