proc (o) = order (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      sort rank 
; -----------------------------------------------------------------
;  Keywords      order statistics, rank statistics
; -----------------------------------------------------------------
;   Macro        order
; -----------------------------------------------------------------
;   Description  Computes the order vector of a given vector.
; -----------------------------------------------------------------
;   Usage        o = order (x)
;   Input
;     Parameter  x  
;     Definition n vector
;   Output
;     Parameter  o
;     Definition n vector consisting of the order values
; -----------------------------------------------------------------
;   Example   library("xplore")
;             x = #(4,1,6,5)
;             order (x)
; -----------------------------------------------------------------
;   Result
;       Contents of o
;       [1,]     2 
;       [2,]     1 
;       [3,]     4 
;       [4,]     3 
; -----------------------------------------------------------------
;   Author    TTK, 960613
; -----------------------------------------------------------------

  i = 1:rows (x)
  o = sort (i~x, 2)[,1]

endp

